/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.route53.endpoints.Route53EndpointParams;
import software.amazon.awssdk.services.route53.endpoints.Route53EndpointProvider;
import software.amazon.awssdk.services.route53.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.route53.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.route53.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultRoute53EndpointProvider
implements Route53EndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(Route53EndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultRoute53EndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(Route53EndpointParams params, LocalState locals) {
        RuleResult result = DefaultRoute53EndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultRoute53EndpointProvider.endpointRule5(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultRoute53EndpointProvider.endpointRule29(params, locals);
    }

    private static RuleResult endpointRule1(Route53EndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultRoute53EndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53EndpointProvider.endpointRule4(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(Route53EndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(Route53EndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(Route53EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule5(Route53EndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultRoute53EndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(Route53EndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultRoute53EndpointProvider.endpointRule7(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule9(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53EndpointProvider.endpointRule24(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53EndpointProvider.endpointRule28(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(Route53EndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(Route53EndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-fips.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(Route53EndpointParams params, LocalState locals) {
        if ("aws-cn".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53.amazonaws.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("cn-northwest-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(Route53EndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53.us-gov.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("us-gov-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(Route53EndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53.us-gov.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("us-gov-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(Route53EndpointParams params, LocalState locals) {
        if ("aws-iso".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53.c2s.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("us-iso-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(Route53EndpointParams params, LocalState locals) {
        if ("aws-iso-b".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53.sc2s.sgov.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("us-isob-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(Route53EndpointParams params, LocalState locals) {
        if ("aws-iso-e".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53.cloud.adc-e.uk")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("eu-isoe-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(Route53EndpointParams params, LocalState locals) {
        if ("aws-iso-f".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53.csp.hci.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("route53").signingRegion("us-isof-south-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(Route53EndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultRoute53EndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53EndpointProvider.endpointRule19(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(Route53EndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultRoute53EndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(Route53EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule19(Route53EndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule20(Route53EndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultRoute53EndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53EndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(Route53EndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultRoute53EndpointProvider.endpointRule22(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(Route53EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule23(Route53EndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule24(Route53EndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultRoute53EndpointProvider.endpointRule25(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53EndpointProvider.endpointRule27(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(Route53EndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultRoute53EndpointProvider.endpointRule26(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(Route53EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule27(Route53EndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule28(Route53EndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule29(Route53EndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

