/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;

public class ListHealthChecksIterable
implements SdkIterable<ListHealthChecksResponse> {
    private final Route53Client client;
    private final ListHealthChecksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHealthChecksIterable(Route53Client client, ListHealthChecksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHealthChecksResponseFetcher();
    }

    public Iterator<ListHealthChecksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HealthCheck> healthChecks() {
        Function<ListHealthChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthChecks() != null) {
                return response.healthChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHealthChecksResponseFetcher
    implements SyncPageFetcher<ListHealthChecksResponse> {
        private ListHealthChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListHealthChecksResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListHealthChecksResponse nextPage(ListHealthChecksResponse previousPage) {
            if (previousPage == null) {
                return ListHealthChecksIterable.this.client.listHealthChecks(ListHealthChecksIterable.this.firstRequest);
            }
            return ListHealthChecksIterable.this.client.listHealthChecks((ListHealthChecksRequest)((Object)ListHealthChecksIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

