/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the requested limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountLimitResponse extends Route53Response implements
        ToCopyableBuilder<GetAccountLimitResponse.Builder, GetAccountLimitResponse> {
    private static final SdkField<AccountLimit> LIMIT_FIELD = SdkField
            .<AccountLimit> builder(MarshallingType.SDK_POJO)
            .memberName("Limit")
            .getter(getter(GetAccountLimitResponse::limit))
            .setter(setter(Builder::limit))
            .constructor(AccountLimit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit")
                    .unmarshallLocationName("Limit").build()).build();

    private static final SdkField<Long> COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("Count")
            .getter(getter(GetAccountLimitResponse::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("Count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AccountLimit limit;

    private final Long count;

    private GetAccountLimitResponse(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.count = builder.count;
    }

    /**
     * <p>
     * The current setting for the specified limit. For example, if you specified
     * <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of
     * <code>Limit</code> is the maximum number of health checks that you can create using the current account.
     * </p>
     * 
     * @return The current setting for the specified limit. For example, if you specified
     *         <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of
     *         <code>Limit</code> is the maximum number of health checks that you can create using the current account.
     */
    public final AccountLimit limit() {
        return limit;
    }

    /**
     * <p>
     * The current number of entities that you have created of the specified type. For example, if you specified
     * <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of
     * <code>Count</code> is the current number of health checks that you have created using the current account.
     * </p>
     * 
     * @return The current number of entities that you have created of the specified type. For example, if you specified
     *         <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of
     *         <code>Count</code> is the current number of health checks that you have created using the current
     *         account.
     */
    public final Long count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountLimitResponse)) {
            return false;
        }
        GetAccountLimitResponse other = (GetAccountLimitResponse) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountLimitResponse").add("Limit", limit()).add("Count", count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Limit", LIMIT_FIELD);
        map.put("Count", COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountLimitResponse, T> g) {
        return obj -> g.apply((GetAccountLimitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountLimitResponse> {
        /**
         * <p>
         * The current setting for the specified limit. For example, if you specified
         * <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of
         * <code>Limit</code> is the maximum number of health checks that you can create using the current account.
         * </p>
         * 
         * @param limit
         *        The current setting for the specified limit. For example, if you specified
         *        <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value
         *        of <code>Limit</code> is the maximum number of health checks that you can create using the current
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(AccountLimit limit);

        /**
         * <p>
         * The current setting for the specified limit. For example, if you specified
         * <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of
         * <code>Limit</code> is the maximum number of health checks that you can create using the current account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountLimit.Builder} avoiding the need
         * to create one manually via {@link AccountLimit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountLimit.Builder#build()} is called immediately and its
         * result is passed to {@link #limit(AccountLimit)}.
         * 
         * @param limit
         *        a consumer that will call methods on {@link AccountLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limit(AccountLimit)
         */
        default Builder limit(Consumer<AccountLimit.Builder> limit) {
            return limit(AccountLimit.builder().applyMutation(limit).build());
        }

        /**
         * <p>
         * The current number of entities that you have created of the specified type. For example, if you specified
         * <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of
         * <code>Count</code> is the current number of health checks that you have created using the current account.
         * </p>
         * 
         * @param count
         *        The current number of entities that you have created of the specified type. For example, if you
         *        specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request,
         *        the value of <code>Count</code> is the current number of health checks that you have created using the
         *        current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private AccountLimit limit;

        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountLimitResponse model) {
            super(model);
            limit(model.limit);
            count(model.count);
        }

        public final AccountLimit.Builder getLimit() {
            return limit != null ? limit.toBuilder() : null;
        }

        public final void setLimit(AccountLimit.BuilderImpl limit) {
            this.limit = limit != null ? limit.build() : null;
        }

        @Override
        public final Builder limit(AccountLimit limit) {
            this.limit = limit;
            return this;
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        @Override
        public GetAccountLimitResponse build() {
            return new GetAccountLimitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
