/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.TransferDomainRequest;

@SdkInternalApi
public class TransferDomainRequestModelMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> IDNLANGCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdnLangCode").build();
    private static final MarshallingInfo<Integer> DURATIONINYEARS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationInYears").build();
    private static final MarshallingInfo<List> NAMESERVERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Nameservers").build();
    private static final MarshallingInfo<String> AUTHCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthCode").build();
    private static final MarshallingInfo<Boolean> AUTORENEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoRenew").build();
    private static final MarshallingInfo<StructuredPojo> ADMINCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdminContact").build();
    private static final MarshallingInfo<StructuredPojo> REGISTRANTCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrantContact").build();
    private static final MarshallingInfo<StructuredPojo> TECHCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TechContact").build();
    private static final MarshallingInfo<Boolean> PRIVACYPROTECTADMINCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivacyProtectAdminContact").build();
    private static final MarshallingInfo<Boolean> PRIVACYPROTECTREGISTRANTCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivacyProtectRegistrantContact").build();
    private static final MarshallingInfo<Boolean> PRIVACYPROTECTTECHCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivacyProtectTechContact").build();
    private static final TransferDomainRequestModelMarshaller INSTANCE = new TransferDomainRequestModelMarshaller();

    public static TransferDomainRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransferDomainRequest transferDomainRequest, ProtocolMarshaller protocolMarshaller) {
        if (transferDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)transferDomainRequest.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.idnLangCode(), IDNLANGCODE_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.durationInYears(), DURATIONINYEARS_BINDING);
            protocolMarshaller.marshall(transferDomainRequest.nameservers(), NAMESERVERS_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.authCode(), AUTHCODE_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.autoRenew(), AUTORENEW_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.adminContact(), ADMINCONTACT_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.registrantContact(), REGISTRANTCONTACT_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.techContact(), TECHCONTACT_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.privacyProtectAdminContact(), PRIVACYPROTECTADMINCONTACT_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.privacyProtectRegistrantContact(), PRIVACYPROTECTREGISTRANTCONTACT_BINDING);
            protocolMarshaller.marshall((Object)transferDomainRequest.privacyProtectTechContact(), PRIVACYPROTECTTECHCONTACT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

