/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDomainContactPrivacyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDomainContactPrivacyRequest> {
    private final String domainName;
    private final Boolean adminPrivacy;
    private final Boolean registrantPrivacy;
    private final Boolean techPrivacy;

    private UpdateDomainContactPrivacyRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
    }

    public String domainName() {
        return this.domainName;
    }

    public Boolean adminPrivacy() {
        return this.adminPrivacy;
    }

    public Boolean registrantPrivacy() {
        return this.registrantPrivacy;
    }

    public Boolean techPrivacy() {
        return this.techPrivacy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.techPrivacy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactPrivacyRequest)) {
            return false;
        }
        UpdateDomainContactPrivacyRequest other = (UpdateDomainContactPrivacyRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.adminPrivacy(), other.adminPrivacy()) && Objects.equals(this.registrantPrivacy(), other.registrantPrivacy()) && Objects.equals(this.techPrivacy(), other.techPrivacy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.adminPrivacy() != null) {
            sb.append("AdminPrivacy: ").append(this.adminPrivacy()).append(",");
        }
        if (this.registrantPrivacy() != null) {
            sb.append("RegistrantPrivacy: ").append(this.registrantPrivacy()).append(",");
        }
        if (this.techPrivacy() != null) {
            sb.append("TechPrivacy: ").append(this.techPrivacy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "AdminPrivacy": {
                return Optional.of(clazz.cast(this.adminPrivacy()));
            }
            case "RegistrantPrivacy": {
                return Optional.of(clazz.cast(this.registrantPrivacy()));
            }
            case "TechPrivacy": {
                return Optional.of(clazz.cast(this.techPrivacy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Boolean adminPrivacy;
        private Boolean registrantPrivacy;
        private Boolean techPrivacy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactPrivacyRequest model) {
            this.domainName(model.domainName);
            this.adminPrivacy(model.adminPrivacy);
            this.registrantPrivacy(model.registrantPrivacy);
            this.techPrivacy(model.techPrivacy);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAdminPrivacy() {
            return this.adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return this.registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return this.techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        public UpdateDomainContactPrivacyRequest build() {
            return new UpdateDomainContactPrivacyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDomainContactPrivacyRequest> {
        public Builder domainName(String var1);

        public Builder adminPrivacy(Boolean var1);

        public Builder registrantPrivacy(Boolean var1);

        public Builder techPrivacy(Boolean var1);
    }
}

