/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53domains.model.TagKeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteTagsForDomainRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteTagsForDomainRequest> {
    private final String domainName;
    private final List<String> tagsToDelete;

    private DeleteTagsForDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.tagsToDelete = builder.tagsToDelete;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> tagsToDelete() {
        return this.tagsToDelete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagsToDelete());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsForDomainRequest)) {
            return false;
        }
        DeleteTagsForDomainRequest other = (DeleteTagsForDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.tagsToDelete(), other.tagsToDelete());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.tagsToDelete() != null) {
            sb.append("TagsToDelete: ").append(this.tagsToDelete()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "TagsToDelete": {
                return Optional.of(clazz.cast(this.tagsToDelete()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> tagsToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsForDomainRequest model) {
            this.domainName(model.domainName);
            this.tagsToDelete(model.tagsToDelete);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getTagsToDelete() {
            return this.tagsToDelete;
        }

        @Override
        public final Builder tagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToDelete(String ... tagsToDelete) {
            this.tagsToDelete(Arrays.asList(tagsToDelete));
            return this;
        }

        public final void setTagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
        }

        public DeleteTagsForDomainRequest build() {
            return new DeleteTagsForDomainRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteTagsForDomainRequest> {
        public Builder domainName(String var1);

        public Builder tagsToDelete(Collection<String> var1);

        public Builder tagsToDelete(String ... var1);
    }
}

