/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.services.route53.transform.AliasTargetUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GeoLocationUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ResourceRecordUnmarshaller;

public class ResourceRecordSetUnmarshaller
implements Unmarshaller<ResourceRecordSet, StaxUnmarshallerContext> {
    private static final ResourceRecordSetUnmarshaller INSTANCE = new ResourceRecordSetUnmarshaller();

    public ResourceRecordSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceRecordSet.Builder resourceRecordSet;
        block17: {
            resourceRecordSet = ResourceRecordSet.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ResourceRecord> resourceRecords = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    resourceRecordSet.resourceRecords(resourceRecords);
                    break block17;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        resourceRecordSet.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Type", targetDepth)) {
                        resourceRecordSet.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SetIdentifier", targetDepth)) {
                        resourceRecordSet.setIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Weight", targetDepth)) {
                        resourceRecordSet.weight(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Region", targetDepth)) {
                        resourceRecordSet.region(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("GeoLocation", targetDepth)) {
                        resourceRecordSet.geoLocation(GeoLocationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Failover", targetDepth)) {
                        resourceRecordSet.failover(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MultiValueAnswer", targetDepth)) {
                        resourceRecordSet.multiValueAnswer(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TTL", targetDepth)) {
                        resourceRecordSet.ttl(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ResourceRecords", targetDepth)) {
                        resourceRecords = new ArrayList<ResourceRecord>();
                        continue;
                    }
                    if (context.testExpression("ResourceRecords/ResourceRecord", targetDepth)) {
                        resourceRecords.add(ResourceRecordUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AliasTarget", targetDepth)) {
                        resourceRecordSet.aliasTarget(AliasTargetUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HealthCheckId", targetDepth)) {
                        resourceRecordSet.healthCheckId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("TrafficPolicyInstanceId", targetDepth)) continue;
                    resourceRecordSet.trafficPolicyInstanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            resourceRecordSet.resourceRecords(resourceRecords);
        }
        return (ResourceRecordSet)resourceRecordSet.build();
    }

    public static ResourceRecordSetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

