/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.transform.CloudWatchAlarmConfigurationUnmarshaller;
import software.amazon.awssdk.services.route53.transform.HealthCheckConfigUnmarshaller;
import software.amazon.awssdk.services.route53.transform.LinkedServiceUnmarshaller;

public class HealthCheckUnmarshaller
implements Unmarshaller<HealthCheck, StaxUnmarshallerContext> {
    private static final HealthCheckUnmarshaller INSTANCE = new HealthCheckUnmarshaller();

    public HealthCheck unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HealthCheck.Builder healthCheck = HealthCheck.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    healthCheck.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CallerReference", targetDepth)) {
                    healthCheck.callerReference(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LinkedService", targetDepth)) {
                    healthCheck.linkedService(LinkedServiceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckConfig", targetDepth)) {
                    healthCheck.healthCheckConfig(HealthCheckConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckVersion", targetDepth)) {
                    healthCheck.healthCheckVersion(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CloudWatchAlarmConfiguration", targetDepth)) continue;
                healthCheck.cloudWatchAlarmConfiguration(CloudWatchAlarmConfigurationUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HealthCheck)healthCheck.build();
    }

    public static HealthCheckUnmarshaller getInstance() {
        return INSTANCE;
    }
}

