/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTrafficPolicyInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListTrafficPolicyInstancesRequest> {
    private final String hostedZoneIdMarker;
    private final String trafficPolicyInstanceNameMarker;
    private final String trafficPolicyInstanceTypeMarker;
    private final String maxItems;

    private ListTrafficPolicyInstancesRequest(BuilderImpl builder) {
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.maxItems = builder.maxItems;
    }

    public String hostedZoneIdMarker() {
        return this.hostedZoneIdMarker;
    }

    public String trafficPolicyInstanceNameMarker() {
        return this.trafficPolicyInstanceNameMarker;
    }

    public RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(this.trafficPolicyInstanceTypeMarker);
    }

    public String trafficPolicyInstanceTypeMarkerString() {
        return this.trafficPolicyInstanceTypeMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceNameMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceTypeMarkerString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesRequest)) {
            return false;
        }
        ListTrafficPolicyInstancesRequest other = (ListTrafficPolicyInstancesRequest)((Object)obj);
        return Objects.equals(this.hostedZoneIdMarker(), other.hostedZoneIdMarker()) && Objects.equals(this.trafficPolicyInstanceNameMarker(), other.trafficPolicyInstanceNameMarker()) && Objects.equals(this.trafficPolicyInstanceTypeMarkerString(), other.trafficPolicyInstanceTypeMarkerString()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostedZoneIdMarker() != null) {
            sb.append("HostedZoneIdMarker: ").append(this.hostedZoneIdMarker()).append(",");
        }
        if (this.trafficPolicyInstanceNameMarker() != null) {
            sb.append("TrafficPolicyInstanceNameMarker: ").append(this.trafficPolicyInstanceNameMarker()).append(",");
        }
        if (this.trafficPolicyInstanceTypeMarkerString() != null) {
            sb.append("TrafficPolicyInstanceTypeMarker: ").append(this.trafficPolicyInstanceTypeMarkerString()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneIdMarker": {
                return Optional.of(clazz.cast(this.hostedZoneIdMarker()));
            }
            case "TrafficPolicyInstanceNameMarker": {
                return Optional.of(clazz.cast(this.trafficPolicyInstanceNameMarker()));
            }
            case "TrafficPolicyInstanceTypeMarker": {
                return Optional.of(clazz.cast(this.trafficPolicyInstanceTypeMarkerString()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hostedZoneIdMarker;
        private String trafficPolicyInstanceNameMarker;
        private String trafficPolicyInstanceTypeMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesRequest model) {
            this.hostedZoneIdMarker(model.hostedZoneIdMarker);
            this.trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            this.trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            this.maxItems(model.maxItems);
        }

        public final String getHostedZoneIdMarker() {
            return this.hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return this.trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return this.trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListTrafficPolicyInstancesRequest build() {
            return new ListTrafficPolicyInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTrafficPolicyInstancesRequest> {
        public Builder hostedZoneIdMarker(String var1);

        public Builder trafficPolicyInstanceNameMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(RRType var1);

        public Builder maxItems(String var1);
    }
}

