/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourceRecordSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListResourceRecordSetsResponse> {
    private final List<ResourceRecordSet> resourceRecordSets;
    private final Boolean isTruncated;
    private final String nextRecordName;
    private final String nextRecordType;
    private final String nextRecordIdentifier;
    private final String maxItems;

    private ListResourceRecordSetsResponse(BuilderImpl builder) {
        this.resourceRecordSets = builder.resourceRecordSets;
        this.isTruncated = builder.isTruncated;
        this.nextRecordName = builder.nextRecordName;
        this.nextRecordType = builder.nextRecordType;
        this.nextRecordIdentifier = builder.nextRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    public List<ResourceRecordSet> resourceRecordSets() {
        return this.resourceRecordSets;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextRecordName() {
        return this.nextRecordName;
    }

    public RRType nextRecordType() {
        return RRType.fromValue(this.nextRecordType);
    }

    public String nextRecordTypeString() {
        return this.nextRecordType;
    }

    public String nextRecordIdentifier() {
        return this.nextRecordIdentifier;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecordSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRecordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRecordTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRecordIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsResponse)) {
            return false;
        }
        ListResourceRecordSetsResponse other = (ListResourceRecordSetsResponse)((Object)obj);
        return Objects.equals(this.resourceRecordSets(), other.resourceRecordSets()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextRecordName(), other.nextRecordName()) && Objects.equals(this.nextRecordTypeString(), other.nextRecordTypeString()) && Objects.equals(this.nextRecordIdentifier(), other.nextRecordIdentifier()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceRecordSets() != null) {
            sb.append("ResourceRecordSets: ").append(this.resourceRecordSets()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextRecordName() != null) {
            sb.append("NextRecordName: ").append(this.nextRecordName()).append(",");
        }
        if (this.nextRecordTypeString() != null) {
            sb.append("NextRecordType: ").append(this.nextRecordTypeString()).append(",");
        }
        if (this.nextRecordIdentifier() != null) {
            sb.append("NextRecordIdentifier: ").append(this.nextRecordIdentifier()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceRecordSets": {
                return Optional.of(clazz.cast(this.resourceRecordSets()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "NextRecordName": {
                return Optional.of(clazz.cast(this.nextRecordName()));
            }
            case "NextRecordType": {
                return Optional.of(clazz.cast(this.nextRecordTypeString()));
            }
            case "NextRecordIdentifier": {
                return Optional.of(clazz.cast(this.nextRecordIdentifier()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourceRecordSet> resourceRecordSets;
        private Boolean isTruncated;
        private String nextRecordName;
        private String nextRecordType;
        private String nextRecordIdentifier;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsResponse model) {
            this.resourceRecordSets(model.resourceRecordSets);
            this.isTruncated(model.isTruncated);
            this.nextRecordName(model.nextRecordName);
            this.nextRecordType(model.nextRecordType);
            this.nextRecordIdentifier(model.nextRecordIdentifier);
            this.maxItems(model.maxItems);
        }

        public final Collection<ResourceRecordSet.Builder> getResourceRecordSets() {
            return this.resourceRecordSets != null ? (Collection)this.resourceRecordSets.stream().map(ResourceRecordSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copy(resourceRecordSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecordSets(ResourceRecordSet ... resourceRecordSets) {
            this.resourceRecordSets(Arrays.asList(resourceRecordSets));
            return this;
        }

        public final void setResourceRecordSets(Collection<ResourceRecordSet.BuilderImpl> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copyFromBuilder(resourceRecordSets);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextRecordName() {
            return this.nextRecordName;
        }

        @Override
        public final Builder nextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
            return this;
        }

        public final void setNextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
        }

        public final String getNextRecordType() {
            return this.nextRecordType;
        }

        @Override
        public final Builder nextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
            return this;
        }

        @Override
        public final Builder nextRecordType(RRType nextRecordType) {
            this.nextRecordType(nextRecordType.toString());
            return this;
        }

        public final void setNextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
        }

        public final String getNextRecordIdentifier() {
            return this.nextRecordIdentifier;
        }

        @Override
        public final Builder nextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
            return this;
        }

        public final void setNextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListResourceRecordSetsResponse build() {
            return new ListResourceRecordSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListResourceRecordSetsResponse> {
        public Builder resourceRecordSets(Collection<ResourceRecordSet> var1);

        public Builder resourceRecordSets(ResourceRecordSet ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextRecordName(String var1);

        public Builder nextRecordType(String var1);

        public Builder nextRecordType(RRType var1);

        public Builder nextRecordIdentifier(String var1);

        public Builder maxItems(String var1);
    }
}

