/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.services.route53.model.VPCsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHostedZoneResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetHostedZoneResponse> {
    private final HostedZone hostedZone;
    private final DelegationSet delegationSet;
    private final List<VPC> vpCs;

    private GetHostedZoneResponse(BuilderImpl builder) {
        this.hostedZone = builder.hostedZone;
        this.delegationSet = builder.delegationSet;
        this.vpCs = builder.vpCs;
    }

    public HostedZone hostedZone() {
        return this.hostedZone;
    }

    public DelegationSet delegationSet() {
        return this.delegationSet;
    }

    public List<VPC> vpCs() {
        return this.vpCs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpCs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneResponse)) {
            return false;
        }
        GetHostedZoneResponse other = (GetHostedZoneResponse)((Object)obj);
        return Objects.equals(this.hostedZone(), other.hostedZone()) && Objects.equals(this.delegationSet(), other.delegationSet()) && Objects.equals(this.vpCs(), other.vpCs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostedZone() != null) {
            sb.append("HostedZone: ").append(this.hostedZone()).append(",");
        }
        if (this.delegationSet() != null) {
            sb.append("DelegationSet: ").append(this.delegationSet()).append(",");
        }
        if (this.vpCs() != null) {
            sb.append("VPCs: ").append(this.vpCs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZone": {
                return Optional.of(clazz.cast(this.hostedZone()));
            }
            case "DelegationSet": {
                return Optional.of(clazz.cast(this.delegationSet()));
            }
            case "VPCs": {
                return Optional.of(clazz.cast(this.vpCs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private HostedZone hostedZone;
        private DelegationSet delegationSet;
        private List<VPC> vpCs;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneResponse model) {
            this.hostedZone(model.hostedZone);
            this.delegationSet(model.delegationSet);
            this.vpCs(model.vpCs);
        }

        public final HostedZone.Builder getHostedZone() {
            return this.hostedZone != null ? this.hostedZone.toBuilder() : null;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        public final DelegationSet.Builder getDelegationSet() {
            return this.delegationSet != null ? this.delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        public final Collection<VPC.Builder> getVPCs() {
            return this.vpCs != null ? (Collection)this.vpCs.stream().map(VPC::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC ... vpCs) {
            this.vpCs(Arrays.asList(vpCs));
            return this;
        }

        public final void setVPCs(Collection<VPC.BuilderImpl> vpCs) {
            this.vpCs = VPCsCopier.copyFromBuilder(vpCs);
        }

        public GetHostedZoneResponse build() {
            return new GetHostedZoneResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetHostedZoneResponse> {
        public Builder hostedZone(HostedZone var1);

        default public Builder hostedZone(Consumer<HostedZone.Builder> hostedZone) {
            return this.hostedZone((HostedZone)((HostedZone.Builder)HostedZone.builder().apply(hostedZone)).build());
        }

        public Builder delegationSet(DelegationSet var1);

        default public Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return this.delegationSet((DelegationSet)((DelegationSet.Builder)DelegationSet.builder().apply(delegationSet)).build());
        }

        public Builder vpCs(Collection<VPC> var1);

        public Builder vpCs(VPC ... var1);
    }
}

