/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.AccountLimit;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAccountLimitResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetAccountLimitResponse> {
    private final AccountLimit limit;
    private final Long count;

    private GetAccountLimitResponse(BuilderImpl builder) {
        this.limit = builder.limit;
        this.count = builder.count;
    }

    public AccountLimit limit() {
        return this.limit;
    }

    public Long count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountLimitResponse)) {
            return false;
        }
        GetAccountLimitResponse other = (GetAccountLimitResponse)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.count(), other.count());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Count": {
                return Optional.of(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private AccountLimit limit;
        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountLimitResponse model) {
            this.limit(model.limit);
            this.count(model.count);
        }

        public final AccountLimit.Builder getLimit() {
            return this.limit != null ? this.limit.toBuilder() : null;
        }

        @Override
        public final Builder limit(AccountLimit limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(AccountLimit.BuilderImpl limit) {
            this.limit = limit != null ? limit.build() : null;
        }

        public final Long getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        public GetAccountLimitResponse build() {
            return new GetAccountLimitResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetAccountLimitResponse> {
        public Builder limit(AccountLimit var1);

        default public Builder limit(Consumer<AccountLimit.Builder> limit) {
            return this.limit((AccountLimit)((AccountLimit.Builder)AccountLimit.builder().apply(limit)).build());
        }

        public Builder count(Long var1);
    }
}

