/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GetDomainDetail response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainDetailResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDomainDetailResponse.Builder, GetDomainDetailResponse> {
    private final String domainName;

    private final List<Nameserver> nameservers;

    private final Boolean autoRenew;

    private final ContactDetail adminContact;

    private final ContactDetail registrantContact;

    private final ContactDetail techContact;

    private final Boolean adminPrivacy;

    private final Boolean registrantPrivacy;

    private final Boolean techPrivacy;

    private final String registrarName;

    private final String whoIsServer;

    private final String registrarUrl;

    private final String abuseContactEmail;

    private final String abuseContactPhone;

    private final String registryDomainId;

    private final Date creationDate;

    private final Date updatedDate;

    private final Date expirationDate;

    private final String reseller;

    private final String dnsSec;

    private final List<String> statusList;

    private GetDomainDetailResponse(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.nameservers = builder.nameservers;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
        this.registrarName = builder.registrarName;
        this.whoIsServer = builder.whoIsServer;
        this.registrarUrl = builder.registrarUrl;
        this.abuseContactEmail = builder.abuseContactEmail;
        this.abuseContactPhone = builder.abuseContactPhone;
        this.registryDomainId = builder.registryDomainId;
        this.creationDate = builder.creationDate;
        this.updatedDate = builder.updatedDate;
        this.expirationDate = builder.expirationDate;
        this.reseller = builder.reseller;
        this.dnsSec = builder.dnsSec;
        this.statusList = builder.statusList;
    }

    /**
     * <p>
     * The name of a domain.
     * </p>
     * 
     * @return The name of a domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public List<Nameserver> nameservers() {
        return nameservers;
    }

    /**
     * <p>
     * Specifies whether the domain registration is set to renew automatically.
     * </p>
     * 
     * @return Specifies whether the domain registration is set to renew automatically.
     */
    public Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * Provides details about the domain administrative contact.
     * </p>
     * 
     * @return Provides details about the domain administrative contact.
     */
    public ContactDetail adminContact() {
        return adminContact;
    }

    /**
     * <p>
     * Provides details about the domain registrant.
     * </p>
     * 
     * @return Provides details about the domain registrant.
     */
    public ContactDetail registrantContact() {
        return registrantContact;
    }

    /**
     * <p>
     * Provides details about the domain technical contact.
     * </p>
     * 
     * @return Provides details about the domain technical contact.
     */
    public ContactDetail techContact() {
        return techContact;
    }

    /**
     * <p>
     * Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the value is
     * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
     * instead of the contact information that you enter.
     * </p>
     * 
     * @return Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the value
     *         is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner,
     *         Gandi, instead of the contact information that you enter.
     */
    public Boolean adminPrivacy() {
        return adminPrivacy;
    }

    /**
     * <p>
     * Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If the value is
     * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
     * instead of the contact information that you enter.
     * </p>
     * 
     * @return Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If the
     *         value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar
     *         partner, Gandi, instead of the contact information that you enter.
     */
    public Boolean registrantPrivacy() {
        return registrantPrivacy;
    }

    /**
     * <p>
     * Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the value is
     * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
     * instead of the contact information that you enter.
     * </p>
     * 
     * @return Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the value
     *         is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner,
     *         Gandi, instead of the contact information that you enter.
     */
    public Boolean techPrivacy() {
        return techPrivacy;
    }

    /**
     * <p>
     * Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are registered by
     * registrar Gandi. The value is <code>"GANDI SAS"</code>.
     * </p>
     * 
     * @return Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are registered
     *         by registrar Gandi. The value is <code>"GANDI SAS"</code>.
     */
    public String registrarName() {
        return registrarName;
    }

    /**
     * <p>
     * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     * </p>
     * 
     * @return The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     */
    public String whoIsServer() {
        return whoIsServer;
    }

    /**
     * <p>
     * Web address of the registrar.
     * </p>
     * 
     * @return Web address of the registrar.
     */
    public String registrarUrl() {
        return registrarUrl;
    }

    /**
     * <p>
     * Email address to contact to report incorrect contact information for a domain, to report that the domain is being
     * used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
     * </p>
     * 
     * @return Email address to contact to report incorrect contact information for a domain, to report that the domain
     *         is being used to send spam, to report that someone is cybersquatting on a domain name, or report some
     *         other type of abuse.
     */
    public String abuseContactEmail() {
        return abuseContactEmail;
    }

    /**
     * <p>
     * Phone number for reporting abuse.
     * </p>
     * 
     * @return Phone number for reporting abuse.
     */
    public String abuseContactPhone() {
        return abuseContactPhone;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String registryDomainId() {
        return registryDomainId;
    }

    /**
     * <p>
     * The date when the domain was created as found in the response to a WHOIS query. The date format is Unix time.
     * </p>
     * 
     * @return The date when the domain was created as found in the response to a WHOIS query. The date format is Unix
     *         time.
     */
    public Date creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix time.
     * </p>
     * 
     * @return The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix
     *         time.
     */
    public Date updatedDate() {
        return updatedDate;
    }

    /**
     * <p>
     * The date when the registration for the domain is set to expire. The date format is Unix time.
     * </p>
     * 
     * @return The date when the registration for the domain is set to expire. The date format is Unix time.
     */
    public Date expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have
     * <code>"Amazon"</code> as the reseller.
     * </p>
     * 
     * @return Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have
     *         <code>"Amazon"</code> as the reseller.
     */
    public String reseller() {
        return reseller;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String dnsSec() {
        return dnsSec;
    }

    /**
     * <p>
     * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
     * </p>
     * <p>
     * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
     * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
     * domain name, transferring a domain name to another registrar, renewing the registration for a domain name, and so
     * on. All registrars use this same set of status codes.
     * </p>
     * <p>
     * For a current list of domain name status codes and an explanation of what each code means, go to the <a
     * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
     * ICANN website; web searches sometimes return an old version of the document.)
     * </p>
     * 
     * @return An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
     *         codes.</p>
     *         <p>
     *         ICANN, the organization that maintains a central database of domain names, has developed a set of domain
     *         name status codes that tell you the status of a variety of operations on a domain name, for example,
     *         registering a domain name, transferring a domain name to another registrar, renewing the registration for
     *         a domain name, and so on. All registrars use this same set of status codes.
     *         </p>
     *         <p>
     *         For a current list of domain name status codes and an explanation of what each code means, go to the <a
     *         href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on
     *         the ICANN website; web searches sometimes return an old version of the document.)
     */
    public List<String> statusList() {
        return statusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((nameservers() == null) ? 0 : nameservers().hashCode());
        hashCode = 31 * hashCode + ((autoRenew() == null) ? 0 : autoRenew().hashCode());
        hashCode = 31 * hashCode + ((adminContact() == null) ? 0 : adminContact().hashCode());
        hashCode = 31 * hashCode + ((registrantContact() == null) ? 0 : registrantContact().hashCode());
        hashCode = 31 * hashCode + ((techContact() == null) ? 0 : techContact().hashCode());
        hashCode = 31 * hashCode + ((adminPrivacy() == null) ? 0 : adminPrivacy().hashCode());
        hashCode = 31 * hashCode + ((registrantPrivacy() == null) ? 0 : registrantPrivacy().hashCode());
        hashCode = 31 * hashCode + ((techPrivacy() == null) ? 0 : techPrivacy().hashCode());
        hashCode = 31 * hashCode + ((registrarName() == null) ? 0 : registrarName().hashCode());
        hashCode = 31 * hashCode + ((whoIsServer() == null) ? 0 : whoIsServer().hashCode());
        hashCode = 31 * hashCode + ((registrarUrl() == null) ? 0 : registrarUrl().hashCode());
        hashCode = 31 * hashCode + ((abuseContactEmail() == null) ? 0 : abuseContactEmail().hashCode());
        hashCode = 31 * hashCode + ((abuseContactPhone() == null) ? 0 : abuseContactPhone().hashCode());
        hashCode = 31 * hashCode + ((registryDomainId() == null) ? 0 : registryDomainId().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((updatedDate() == null) ? 0 : updatedDate().hashCode());
        hashCode = 31 * hashCode + ((expirationDate() == null) ? 0 : expirationDate().hashCode());
        hashCode = 31 * hashCode + ((reseller() == null) ? 0 : reseller().hashCode());
        hashCode = 31 * hashCode + ((dnsSec() == null) ? 0 : dnsSec().hashCode());
        hashCode = 31 * hashCode + ((statusList() == null) ? 0 : statusList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainDetailResponse)) {
            return false;
        }
        GetDomainDetailResponse other = (GetDomainDetailResponse) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.nameservers() == null ^ this.nameservers() == null) {
            return false;
        }
        if (other.nameservers() != null && !other.nameservers().equals(this.nameservers())) {
            return false;
        }
        if (other.autoRenew() == null ^ this.autoRenew() == null) {
            return false;
        }
        if (other.autoRenew() != null && !other.autoRenew().equals(this.autoRenew())) {
            return false;
        }
        if (other.adminContact() == null ^ this.adminContact() == null) {
            return false;
        }
        if (other.adminContact() != null && !other.adminContact().equals(this.adminContact())) {
            return false;
        }
        if (other.registrantContact() == null ^ this.registrantContact() == null) {
            return false;
        }
        if (other.registrantContact() != null && !other.registrantContact().equals(this.registrantContact())) {
            return false;
        }
        if (other.techContact() == null ^ this.techContact() == null) {
            return false;
        }
        if (other.techContact() != null && !other.techContact().equals(this.techContact())) {
            return false;
        }
        if (other.adminPrivacy() == null ^ this.adminPrivacy() == null) {
            return false;
        }
        if (other.adminPrivacy() != null && !other.adminPrivacy().equals(this.adminPrivacy())) {
            return false;
        }
        if (other.registrantPrivacy() == null ^ this.registrantPrivacy() == null) {
            return false;
        }
        if (other.registrantPrivacy() != null && !other.registrantPrivacy().equals(this.registrantPrivacy())) {
            return false;
        }
        if (other.techPrivacy() == null ^ this.techPrivacy() == null) {
            return false;
        }
        if (other.techPrivacy() != null && !other.techPrivacy().equals(this.techPrivacy())) {
            return false;
        }
        if (other.registrarName() == null ^ this.registrarName() == null) {
            return false;
        }
        if (other.registrarName() != null && !other.registrarName().equals(this.registrarName())) {
            return false;
        }
        if (other.whoIsServer() == null ^ this.whoIsServer() == null) {
            return false;
        }
        if (other.whoIsServer() != null && !other.whoIsServer().equals(this.whoIsServer())) {
            return false;
        }
        if (other.registrarUrl() == null ^ this.registrarUrl() == null) {
            return false;
        }
        if (other.registrarUrl() != null && !other.registrarUrl().equals(this.registrarUrl())) {
            return false;
        }
        if (other.abuseContactEmail() == null ^ this.abuseContactEmail() == null) {
            return false;
        }
        if (other.abuseContactEmail() != null && !other.abuseContactEmail().equals(this.abuseContactEmail())) {
            return false;
        }
        if (other.abuseContactPhone() == null ^ this.abuseContactPhone() == null) {
            return false;
        }
        if (other.abuseContactPhone() != null && !other.abuseContactPhone().equals(this.abuseContactPhone())) {
            return false;
        }
        if (other.registryDomainId() == null ^ this.registryDomainId() == null) {
            return false;
        }
        if (other.registryDomainId() != null && !other.registryDomainId().equals(this.registryDomainId())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.updatedDate() == null ^ this.updatedDate() == null) {
            return false;
        }
        if (other.updatedDate() != null && !other.updatedDate().equals(this.updatedDate())) {
            return false;
        }
        if (other.expirationDate() == null ^ this.expirationDate() == null) {
            return false;
        }
        if (other.expirationDate() != null && !other.expirationDate().equals(this.expirationDate())) {
            return false;
        }
        if (other.reseller() == null ^ this.reseller() == null) {
            return false;
        }
        if (other.reseller() != null && !other.reseller().equals(this.reseller())) {
            return false;
        }
        if (other.dnsSec() == null ^ this.dnsSec() == null) {
            return false;
        }
        if (other.dnsSec() != null && !other.dnsSec().equals(this.dnsSec())) {
            return false;
        }
        if (other.statusList() == null ^ this.statusList() == null) {
            return false;
        }
        if (other.statusList() != null && !other.statusList().equals(this.statusList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (nameservers() != null) {
            sb.append("Nameservers: ").append(nameservers()).append(",");
        }
        if (autoRenew() != null) {
            sb.append("AutoRenew: ").append(autoRenew()).append(",");
        }
        if (adminContact() != null) {
            sb.append("AdminContact: ").append(adminContact()).append(",");
        }
        if (registrantContact() != null) {
            sb.append("RegistrantContact: ").append(registrantContact()).append(",");
        }
        if (techContact() != null) {
            sb.append("TechContact: ").append(techContact()).append(",");
        }
        if (adminPrivacy() != null) {
            sb.append("AdminPrivacy: ").append(adminPrivacy()).append(",");
        }
        if (registrantPrivacy() != null) {
            sb.append("RegistrantPrivacy: ").append(registrantPrivacy()).append(",");
        }
        if (techPrivacy() != null) {
            sb.append("TechPrivacy: ").append(techPrivacy()).append(",");
        }
        if (registrarName() != null) {
            sb.append("RegistrarName: ").append(registrarName()).append(",");
        }
        if (whoIsServer() != null) {
            sb.append("WhoIsServer: ").append(whoIsServer()).append(",");
        }
        if (registrarUrl() != null) {
            sb.append("RegistrarUrl: ").append(registrarUrl()).append(",");
        }
        if (abuseContactEmail() != null) {
            sb.append("AbuseContactEmail: ").append(abuseContactEmail()).append(",");
        }
        if (abuseContactPhone() != null) {
            sb.append("AbuseContactPhone: ").append(abuseContactPhone()).append(",");
        }
        if (registryDomainId() != null) {
            sb.append("RegistryDomainId: ").append(registryDomainId()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (updatedDate() != null) {
            sb.append("UpdatedDate: ").append(updatedDate()).append(",");
        }
        if (expirationDate() != null) {
            sb.append("ExpirationDate: ").append(expirationDate()).append(",");
        }
        if (reseller() != null) {
            sb.append("Reseller: ").append(reseller()).append(",");
        }
        if (dnsSec() != null) {
            sb.append("DnsSec: ").append(dnsSec()).append(",");
        }
        if (statusList() != null) {
            sb.append("StatusList: ").append(statusList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDomainDetailResponse> {
        /**
         * <p>
         * The name of a domain.
         * </p>
         * 
         * @param domainName
         *        The name of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param nameservers
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Collection<Nameserver> nameservers);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setNameservers(java.util.Collection)} or {@link #withNameservers(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param nameservers
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Nameserver... nameservers);

        /**
         * <p>
         * Specifies whether the domain registration is set to renew automatically.
         * </p>
         * 
         * @param autoRenew
         *        Specifies whether the domain registration is set to renew automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * Provides details about the domain administrative contact.
         * </p>
         * 
         * @param adminContact
         *        Provides details about the domain administrative contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminContact(ContactDetail adminContact);

        /**
         * <p>
         * Provides details about the domain registrant.
         * </p>
         * 
         * @param registrantContact
         *        Provides details about the domain registrant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantContact(ContactDetail registrantContact);

        /**
         * <p>
         * Provides details about the domain technical contact.
         * </p>
         * 
         * @param techContact
         *        Provides details about the domain technical contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techContact(ContactDetail techContact);

        /**
         * <p>
         * Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the value is
         * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
         * instead of the contact information that you enter.
         * </p>
         * 
         * @param adminPrivacy
         *        Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the
         *        value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar
         *        partner, Gandi, instead of the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPrivacy(Boolean adminPrivacy);

        /**
         * <p>
         * Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If the
         * value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar
         * partner, Gandi, instead of the contact information that you enter.
         * </p>
         * 
         * @param registrantPrivacy
         *        Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If
         *        the value is <code>true</code>, WHOIS ("who is") queries will return contact information for our
         *        registrar partner, Gandi, instead of the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantPrivacy(Boolean registrantPrivacy);

        /**
         * <p>
         * Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the value is
         * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
         * instead of the contact information that you enter.
         * </p>
         * 
         * @param techPrivacy
         *        Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the
         *        value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar
         *        partner, Gandi, instead of the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techPrivacy(Boolean techPrivacy);

        /**
         * <p>
         * Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are registered by
         * registrar Gandi. The value is <code>"GANDI SAS"</code>.
         * </p>
         * 
         * @param registrarName
         *        Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are
         *        registered by registrar Gandi. The value is <code>"GANDI SAS"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrarName(String registrarName);

        /**
         * <p>
         * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
         * </p>
         * 
         * @param whoIsServer
         *        The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whoIsServer(String whoIsServer);

        /**
         * <p>
         * Web address of the registrar.
         * </p>
         * 
         * @param registrarUrl
         *        Web address of the registrar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrarUrl(String registrarUrl);

        /**
         * <p>
         * Email address to contact to report incorrect contact information for a domain, to report that the domain is
         * being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type
         * of abuse.
         * </p>
         * 
         * @param abuseContactEmail
         *        Email address to contact to report incorrect contact information for a domain, to report that the
         *        domain is being used to send spam, to report that someone is cybersquatting on a domain name, or
         *        report some other type of abuse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abuseContactEmail(String abuseContactEmail);

        /**
         * <p>
         * Phone number for reporting abuse.
         * </p>
         * 
         * @param abuseContactPhone
         *        Phone number for reporting abuse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abuseContactPhone(String abuseContactPhone);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param registryDomainId
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryDomainId(String registryDomainId);

        /**
         * <p>
         * The date when the domain was created as found in the response to a WHOIS query. The date format is Unix time.
         * </p>
         * 
         * @param creationDate
         *        The date when the domain was created as found in the response to a WHOIS query. The date format is
         *        Unix time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Date creationDate);

        /**
         * <p>
         * The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix time.
         * </p>
         * 
         * @param updatedDate
         *        The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedDate(Date updatedDate);

        /**
         * <p>
         * The date when the registration for the domain is set to expire. The date format is Unix time.
         * </p>
         * 
         * @param expirationDate
         *        The date when the registration for the domain is set to expire. The date format is Unix time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Date expirationDate);

        /**
         * <p>
         * Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have
         * <code>"Amazon"</code> as the reseller.
         * </p>
         * 
         * @param reseller
         *        Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have
         *        <code>"Amazon"</code> as the reseller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reseller(String reseller);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param dnsSec
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsSec(String dnsSec);

        /**
         * <p>
         * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
         * </p>
         * <p>
         * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
         * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
         * domain name, transferring a domain name to another registrar, renewing the registration for a domain name,
         * and so on. All registrars use this same set of status codes.
         * </p>
         * <p>
         * For a current list of domain name status codes and an explanation of what each code means, go to the <a
         * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
         * ICANN website; web searches sometimes return an old version of the document.)
         * </p>
         * 
         * @param statusList
         *        An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
         *        codes.</p>
         *        <p>
         *        ICANN, the organization that maintains a central database of domain names, has developed a set of
         *        domain name status codes that tell you the status of a variety of operations on a domain name, for
         *        example, registering a domain name, transferring a domain name to another registrar, renewing the
         *        registration for a domain name, and so on. All registrars use this same set of status codes.
         *        </p>
         *        <p>
         *        For a current list of domain name status codes and an explanation of what each code means, go to the
         *        <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
         *        (Search on the ICANN website; web searches sometimes return an old version of the document.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(Collection<String> statusList);

        /**
         * <p>
         * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
         * </p>
         * <p>
         * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
         * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
         * domain name, transferring a domain name to another registrar, renewing the registration for a domain name,
         * and so on. All registrars use this same set of status codes.
         * </p>
         * <p>
         * For a current list of domain name status codes and an explanation of what each code means, go to the <a
         * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
         * ICANN website; web searches sometimes return an old version of the document.)
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStatusList(java.util.Collection)} or {@link #withStatusList(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param statusList
         *        An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
         *        codes.</p>
         *        <p>
         *        ICANN, the organization that maintains a central database of domain names, has developed a set of
         *        domain name status codes that tell you the status of a variety of operations on a domain name, for
         *        example, registering a domain name, transferring a domain name to another registrar, renewing the
         *        registration for a domain name, and so on. All registrars use this same set of status codes.
         *        </p>
         *        <p>
         *        For a current list of domain name status codes and an explanation of what each code means, go to the
         *        <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
         *        (Search on the ICANN website; web searches sometimes return an old version of the document.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(String... statusList);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private List<Nameserver> nameservers = new SdkInternalList<>();

        private Boolean autoRenew;

        private ContactDetail adminContact;

        private ContactDetail registrantContact;

        private ContactDetail techContact;

        private Boolean adminPrivacy;

        private Boolean registrantPrivacy;

        private Boolean techPrivacy;

        private String registrarName;

        private String whoIsServer;

        private String registrarUrl;

        private String abuseContactEmail;

        private String abuseContactPhone;

        private String registryDomainId;

        private Date creationDate;

        private Date updatedDate;

        private Date expirationDate;

        private String reseller;

        private String dnsSec;

        private List<String> statusList = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainDetailResponse model) {
            setDomainName(model.domainName);
            setNameservers(model.nameservers);
            setAutoRenew(model.autoRenew);
            setAdminContact(model.adminContact);
            setRegistrantContact(model.registrantContact);
            setTechContact(model.techContact);
            setAdminPrivacy(model.adminPrivacy);
            setRegistrantPrivacy(model.registrantPrivacy);
            setTechPrivacy(model.techPrivacy);
            setRegistrarName(model.registrarName);
            setWhoIsServer(model.whoIsServer);
            setRegistrarUrl(model.registrarUrl);
            setAbuseContactEmail(model.abuseContactEmail);
            setAbuseContactPhone(model.abuseContactPhone);
            setRegistryDomainId(model.registryDomainId);
            setCreationDate(model.creationDate);
            setUpdatedDate(model.updatedDate);
            setExpirationDate(model.expirationDate);
            setReseller(model.reseller);
            setDnsSec(model.dnsSec);
            setStatusList(model.statusList);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<Nameserver> getNameservers() {
            return nameservers;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver... nameservers) {
            if (this.nameservers == null) {
                this.nameservers = new SdkInternalList<>(nameservers.length);
            }
            for (Nameserver e : nameservers) {
                this.nameservers.add(e);
            }
            return this;
        }

        public final void setNameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
        }

        @SafeVarargs
        public final void setNameservers(Nameserver... nameservers) {
            if (this.nameservers == null) {
                this.nameservers = new SdkInternalList<>(nameservers.length);
            }
            for (Nameserver e : nameservers) {
                this.nameservers.add(e);
            }
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail getAdminContact() {
            return adminContact;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
        }

        public final ContactDetail getRegistrantContact() {
            return registrantContact;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
        }

        public final ContactDetail getTechContact() {
            return techContact;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail techContact) {
            this.techContact = techContact;
        }

        public final Boolean getAdminPrivacy() {
            return adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        public final String getRegistrarName() {
            return registrarName;
        }

        @Override
        public final Builder registrarName(String registrarName) {
            this.registrarName = registrarName;
            return this;
        }

        public final void setRegistrarName(String registrarName) {
            this.registrarName = registrarName;
        }

        public final String getWhoIsServer() {
            return whoIsServer;
        }

        @Override
        public final Builder whoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
            return this;
        }

        public final void setWhoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
        }

        public final String getRegistrarUrl() {
            return registrarUrl;
        }

        @Override
        public final Builder registrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
            return this;
        }

        public final void setRegistrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
        }

        public final String getAbuseContactEmail() {
            return abuseContactEmail;
        }

        @Override
        public final Builder abuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
            return this;
        }

        public final void setAbuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
        }

        public final String getAbuseContactPhone() {
            return abuseContactPhone;
        }

        @Override
        public final Builder abuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
            return this;
        }

        public final void setAbuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
        }

        public final String getRegistryDomainId() {
            return registryDomainId;
        }

        @Override
        public final Builder registryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
            return this;
        }

        public final void setRegistryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
        }

        public final Date getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
        }

        public final Date getUpdatedDate() {
            return updatedDate;
        }

        @Override
        public final Builder updatedDate(Date updatedDate) {
            this.updatedDate = StandardMemberCopier.copy(updatedDate);
            return this;
        }

        public final void setUpdatedDate(Date updatedDate) {
            this.updatedDate = StandardMemberCopier.copy(updatedDate);
        }

        public final Date getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Date expirationDate) {
            this.expirationDate = StandardMemberCopier.copy(expirationDate);
            return this;
        }

        public final void setExpirationDate(Date expirationDate) {
            this.expirationDate = StandardMemberCopier.copy(expirationDate);
        }

        public final String getReseller() {
            return reseller;
        }

        @Override
        public final Builder reseller(String reseller) {
            this.reseller = reseller;
            return this;
        }

        public final void setReseller(String reseller) {
            this.reseller = reseller;
        }

        public final String getDnsSec() {
            return dnsSec;
        }

        @Override
        public final Builder dnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
            return this;
        }

        public final void setDnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
        }

        public final Collection<String> getStatusList() {
            return statusList;
        }

        @Override
        public final Builder statusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(String... statusList) {
            if (this.statusList == null) {
                this.statusList = new SdkInternalList<>(statusList.length);
            }
            for (String e : statusList) {
                this.statusList.add(e);
            }
            return this;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
        }

        @SafeVarargs
        public final void setStatusList(String... statusList) {
            if (this.statusList == null) {
                this.statusList = new SdkInternalList<>(statusList.length);
            }
            for (String e : statusList) {
                this.statusList.add(e);
            }
        }

        @Override
        public GetDomainDetailResponse build() {
            return new GetDomainDetailResponse(this);
        }
    }
}
