/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.DomainSuggestionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about one suggested domain name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DomainSuggestion implements StructuredPojo, ToCopyableBuilder<DomainSuggestion.Builder, DomainSuggestion> {
    private final String domainName;

    private final String availability;

    private DomainSuggestion(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.availability = builder.availability;
    }

    /**
     * <p>
     * A suggested domain name.
     * </p>
     * 
     * @return A suggested domain name.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Whether the domain name is available for registering.
     * </p>
     * <note>
     * <p>
     * You can register only the domains that are designated as <code>AVAILABLE</code>.
     * </p>
     * </note>
     * <p>
     * Valid values:
     * </p>
     * <dl>
     * <dt>AVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is available.
     * </p>
     * </dd>
     * <dt>AVAILABLE_RESERVED</dt>
     * <dd>
     * <p>
     * The domain name is reserved under specific conditions.
     * </p>
     * </dd>
     * <dt>AVAILABLE_PREORDER</dt>
     * <dd>
     * <p>
     * The domain name is available and can be preordered.
     * </p>
     * </dd>
     * <dt>DONT_KNOW</dt>
     * <dd>
     * <p>
     * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon Route
     * 53 can return this response for a variety of reasons, for example, the registry is performing maintenance. Try
     * again later.
     * </p>
     * </dd>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
     * usually takes just a few extra seconds. You can resubmit the request immediately.
     * </p>
     * </dd>
     * <dt>RESERVED</dt>
     * <dd>
     * <p>
     * The domain name has been reserved for another person or organization.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_PREMIUM</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_RESTRICTED</dt>
     * <dd>
     * <p>
     * The domain name is forbidden.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return Whether the domain name is available for registering.</p> <note>
     *         <p>
     *         You can register only the domains that are designated as <code>AVAILABLE</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Valid values:
     *         </p>
     *         <dl>
     *         <dt>AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is available.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name is reserved under specific conditions.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_PREORDER</dt>
     *         <dd>
     *         <p>
     *         The domain name is available and can be preordered.
     *         </p>
     *         </dd>
     *         <dt>DONT_KNOW</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
     *         Route 53 can return this response for a variety of reasons, for example, the registry is performing
     *         maintenance. Try again later.
     *         </p>
     *         </dd>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
     *         it usually takes just a few extra seconds. You can resubmit the request immediately.
     *         </p>
     *         </dd>
     *         <dt>RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name has been reserved for another person or organization.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_PREMIUM</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_RESTRICTED</dt>
     *         <dd>
     *         <p>
     *         The domain name is forbidden.
     *         </p>
     *         </dd>
     */
    public String availability() {
        return availability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((availability() == null) ? 0 : availability().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSuggestion)) {
            return false;
        }
        DomainSuggestion other = (DomainSuggestion) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.availability() == null ^ this.availability() == null) {
            return false;
        }
        if (other.availability() != null && !other.availability().equals(this.availability())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (availability() != null) {
            sb.append("Availability: ").append(availability()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainSuggestionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DomainSuggestion> {
        /**
         * <p>
         * A suggested domain name.
         * </p>
         * 
         * @param domainName
         *        A suggested domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Whether the domain name is available for registering.
         * </p>
         * <note>
         * <p>
         * You can register only the domains that are designated as <code>AVAILABLE</code>.
         * </p>
         * </note>
         * <p>
         * Valid values:
         * </p>
         * <dl>
         * <dt>AVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is available.
         * </p>
         * </dd>
         * <dt>AVAILABLE_RESERVED</dt>
         * <dd>
         * <p>
         * The domain name is reserved under specific conditions.
         * </p>
         * </dd>
         * <dt>AVAILABLE_PREORDER</dt>
         * <dd>
         * <p>
         * The domain name is available and can be preordered.
         * </p>
         * </dd>
         * <dt>DONT_KNOW</dt>
         * <dd>
         * <p>
         * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
         * Route 53 can return this response for a variety of reasons, for example, the registry is performing
         * maintenance. Try again later.
         * </p>
         * </dd>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
         * usually takes just a few extra seconds. You can resubmit the request immediately.
         * </p>
         * </dd>
         * <dt>RESERVED</dt>
         * <dd>
         * <p>
         * The domain name has been reserved for another person or organization.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_PREMIUM</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_RESTRICTED</dt>
         * <dd>
         * <p>
         * The domain name is forbidden.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param availability
         *        Whether the domain name is available for registering.</p> <note>
         *        <p>
         *        You can register only the domains that are designated as <code>AVAILABLE</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Valid values:
         *        </p>
         *        <dl>
         *        <dt>AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is available.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name is reserved under specific conditions.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_PREORDER</dt>
         *        <dd>
         *        <p>
         *        The domain name is available and can be preordered.
         *        </p>
         *        </dd>
         *        <dt>DONT_KNOW</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't reply with a definitive answer about whether the domain name is available.
         *        Amazon Route 53 can return this response for a variety of reasons, for example, the registry is
         *        performing maintenance. Try again later.
         *        </p>
         *        </dd>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't return a response in the expected amount of time. When the response is
         *        delayed, it usually takes just a few extra seconds. You can resubmit the request immediately.
         *        </p>
         *        </dd>
         *        <dt>RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name has been reserved for another person or organization.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_PREMIUM</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_RESTRICTED</dt>
         *        <dd>
         *        <p>
         *        The domain name is forbidden.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availability(String availability);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private String availability;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSuggestion model) {
            setDomainName(model.domainName);
            setAvailability(model.availability);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getAvailability() {
            return availability;
        }

        @Override
        public final Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        public final void setAvailability(String availability) {
            this.availability = availability;
        }

        @Override
        public DomainSuggestion build() {
            return new DomainSuggestion(this);
        }
    }
}
