/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the resource record sets that you want to update based on a specified
 * traffic policy instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTrafficPolicyInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateTrafficPolicyInstanceRequest.Builder, UpdateTrafficPolicyInstanceRequest> {
    private final String id;

    private final Long ttl;

    private final String trafficPolicyId;

    private final Integer trafficPolicyVersion;

    private UpdateTrafficPolicyInstanceRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.ttl = builder.ttl;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
    }

    /**
     * <p>
     * The ID of the traffic policy instance that you want to update.
     * </p>
     * 
     * @return The ID of the traffic policy instance that you want to update.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
     * </p>
     * 
     * @return The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
     */
    public Long ttl() {
        return ttl;
    }

    /**
     * <p>
     * The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
     * specified traffic policy instance.
     * </p>
     * 
     * @return The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
     *         specified traffic policy instance.
     */
    public String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
     * specified traffic policy instance.
     * </p>
     * 
     * @return The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for
     *         the specified traffic policy instance.
     */
    public Integer trafficPolicyVersion() {
        return trafficPolicyVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((ttl() == null) ? 0 : ttl().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyId() == null) ? 0 : trafficPolicyId().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyVersion() == null) ? 0 : trafficPolicyVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyInstanceRequest)) {
            return false;
        }
        UpdateTrafficPolicyInstanceRequest other = (UpdateTrafficPolicyInstanceRequest) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.ttl() == null ^ this.ttl() == null) {
            return false;
        }
        if (other.ttl() != null && !other.ttl().equals(this.ttl())) {
            return false;
        }
        if (other.trafficPolicyId() == null ^ this.trafficPolicyId() == null) {
            return false;
        }
        if (other.trafficPolicyId() != null && !other.trafficPolicyId().equals(this.trafficPolicyId())) {
            return false;
        }
        if (other.trafficPolicyVersion() == null ^ this.trafficPolicyVersion() == null) {
            return false;
        }
        if (other.trafficPolicyVersion() != null && !other.trafficPolicyVersion().equals(this.trafficPolicyVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (ttl() != null) {
            sb.append("TTL: ").append(ttl()).append(",");
        }
        if (trafficPolicyId() != null) {
            sb.append("TrafficPolicyId: ").append(trafficPolicyId()).append(",");
        }
        if (trafficPolicyVersion() != null) {
            sb.append("TrafficPolicyVersion: ").append(trafficPolicyVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateTrafficPolicyInstanceRequest> {
        /**
         * <p>
         * The ID of the traffic policy instance that you want to update.
         * </p>
         * 
         * @param id
         *        The ID of the traffic policy instance that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
         * </p>
         * 
         * @param ttl
         *        The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
         * specified traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for
         *        the specified traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
         * specified traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyVersion
         *        The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets
         *        for the specified traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersion(Integer trafficPolicyVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private Long ttl;

        private String trafficPolicyId;

        private Integer trafficPolicyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyInstanceRequest model) {
            setId(model.id);
            setTTL(model.ttl);
            setTrafficPolicyId(model.trafficPolicyId);
            setTrafficPolicyVersion(model.trafficPolicyVersion);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Long getTTL() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        @Override
        public UpdateTrafficPolicyInstanceRequest build() {
            return new UpdateTrafficPolicyInstanceRequest(this);
        }
    }
}
