/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the traffic policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTrafficPolicyCommentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateTrafficPolicyCommentResponse.Builder, UpdateTrafficPolicyCommentResponse> {
    private final TrafficPolicy trafficPolicy;

    private UpdateTrafficPolicyCommentResponse(BuilderImpl builder) {
        this.trafficPolicy = builder.trafficPolicy;
    }

    /**
     * <p>
     * A complex type that contains settings for the specified traffic policy.
     * </p>
     * 
     * @return A complex type that contains settings for the specified traffic policy.
     */
    public TrafficPolicy trafficPolicy() {
        return trafficPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((trafficPolicy() == null) ? 0 : trafficPolicy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyCommentResponse)) {
            return false;
        }
        UpdateTrafficPolicyCommentResponse other = (UpdateTrafficPolicyCommentResponse) obj;
        if (other.trafficPolicy() == null ^ this.trafficPolicy() == null) {
            return false;
        }
        if (other.trafficPolicy() != null && !other.trafficPolicy().equals(this.trafficPolicy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (trafficPolicy() != null) {
            sb.append("TrafficPolicy: ").append(trafficPolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateTrafficPolicyCommentResponse> {
        /**
         * <p>
         * A complex type that contains settings for the specified traffic policy.
         * </p>
         * 
         * @param trafficPolicy
         *        A complex type that contains settings for the specified traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicy(TrafficPolicy trafficPolicy);
    }

    private static final class BuilderImpl implements Builder {
        private TrafficPolicy trafficPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyCommentResponse model) {
            setTrafficPolicy(model.trafficPolicy);
        }

        public final TrafficPolicy getTrafficPolicy() {
            return trafficPolicy;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        public final void setTrafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
        }

        @Override
        public UpdateTrafficPolicyCommentResponse build() {
            return new UpdateTrafficPolicyCommentResponse(this);
        }
    }
}
