/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateHealthCheckResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateHealthCheckResponse.Builder, UpdateHealthCheckResponse> {
    private final HealthCheck healthCheck;

    private UpdateHealthCheckResponse(BuilderImpl builder) {
        this.healthCheck = builder.healthCheck;
    }

    /**
     *
     * @return
     */
    public HealthCheck healthCheck() {
        return healthCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((healthCheck() == null) ? 0 : healthCheck().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHealthCheckResponse)) {
            return false;
        }
        UpdateHealthCheckResponse other = (UpdateHealthCheckResponse) obj;
        if (other.healthCheck() == null ^ this.healthCheck() == null) {
            return false;
        }
        if (other.healthCheck() != null && !other.healthCheck().equals(this.healthCheck())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (healthCheck() != null) {
            sb.append("HealthCheck: ").append(healthCheck()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateHealthCheckResponse> {
        /**
         *
         * @param healthCheck
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(HealthCheck healthCheck);
    }

    private static final class BuilderImpl implements Builder {
        private HealthCheck healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHealthCheckResponse model) {
            setHealthCheck(model.healthCheck);
        }

        public final HealthCheck getHealthCheck() {
            return healthCheck;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        @Override
        public UpdateHealthCheckResponse build() {
            return new UpdateHealthCheckResponse(this);
        }
    }
}
