/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the latest version of one traffic policy that is associated with the
 * current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrafficPolicySummary implements ToCopyableBuilder<TrafficPolicySummary.Builder, TrafficPolicySummary> {
    private final String id;

    private final String name;

    private final String type;

    private final Integer latestVersion;

    private final Integer trafficPolicyCount;

    private TrafficPolicySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.latestVersion = builder.latestVersion;
        this.trafficPolicyCount = builder.trafficPolicyCount;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the traffic policy when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the traffic policy when you created it.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name that you specified for the traffic policy when you created it.
     * </p>
     * 
     * @return The name that you specified for the traffic policy when you created it.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a
     * traffic policy instance.
     * </p>
     * 
     * @return The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
     *         create a traffic policy instance.
     * @see RRType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The version number of the latest version of the traffic policy.
     * </p>
     * 
     * @return The version number of the latest version of the traffic policy.
     */
    public Integer latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The number of traffic policies that are associated with the current AWS account.
     * </p>
     * 
     * @return The number of traffic policies that are associated with the current AWS account.
     */
    public Integer trafficPolicyCount() {
        return trafficPolicyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((latestVersion() == null) ? 0 : latestVersion().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyCount() == null) ? 0 : trafficPolicyCount().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicySummary)) {
            return false;
        }
        TrafficPolicySummary other = (TrafficPolicySummary) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.latestVersion() == null ^ this.latestVersion() == null) {
            return false;
        }
        if (other.latestVersion() != null && !other.latestVersion().equals(this.latestVersion())) {
            return false;
        }
        if (other.trafficPolicyCount() == null ^ this.trafficPolicyCount() == null) {
            return false;
        }
        if (other.trafficPolicyCount() != null && !other.trafficPolicyCount().equals(this.trafficPolicyCount())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (latestVersion() != null) {
            sb.append("LatestVersion: ").append(latestVersion()).append(",");
        }
        if (trafficPolicyCount() != null) {
            sb.append("TrafficPolicyCount: ").append(trafficPolicyCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TrafficPolicySummary> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the traffic policy when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to the traffic policy when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name that you specified for the traffic policy when you created it.
         * </p>
         * 
         * @param name
         *        The name that you specified for the traffic policy when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create
         * a traffic policy instance.
         * </p>
         * 
         * @param type
         *        The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
         *        create a traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder type(String type);

        /**
         * <p>
         * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create
         * a traffic policy instance.
         * </p>
         * 
         * @param type
         *        The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
         *        create a traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder type(RRType type);

        /**
         * <p>
         * The version number of the latest version of the traffic policy.
         * </p>
         * 
         * @param latestVersion
         *        The version number of the latest version of the traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(Integer latestVersion);

        /**
         * <p>
         * The number of traffic policies that are associated with the current AWS account.
         * </p>
         * 
         * @param trafficPolicyCount
         *        The number of traffic policies that are associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyCount(Integer trafficPolicyCount);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String type;

        private Integer latestVersion;

        private Integer trafficPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicySummary model) {
            setId(model.id);
            setName(model.name);
            setType(model.type);
            setLatestVersion(model.latestVersion);
            setTrafficPolicyCount(model.trafficPolicyCount);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(RRType type) {
            this.type(type.toString());
        }

        public final Integer getLatestVersion() {
            return latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final Integer getTrafficPolicyCount() {
            return trafficPolicyCount;
        }

        @Override
        public final Builder trafficPolicyCount(Integer trafficPolicyCount) {
            this.trafficPolicyCount = trafficPolicyCount;
            return this;
        }

        public final void setTrafficPolicyCount(Integer trafficPolicyCount) {
            this.trafficPolicyCount = trafficPolicyCount;
        }

        @Override
        public TrafficPolicySummary build() {
            return new TrafficPolicySummary(this);
        }
    }
}
