/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information specific to the resource record.
 * </p>
 * <note>
 * <p>
 * If you're creating an alias resource record set, omit <code>ResourceRecord</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceRecord implements ToCopyableBuilder<ResourceRecord.Builder, ResourceRecord> {
    private final String value;

    private ResourceRecord(BuilderImpl builder) {
        this.value = builder.value;
    }

    /**
     * <p>
     * The current or new DNS record value, not to exceed 4,000 characters. In the case of a <code>DELETE</code> action,
     * if the current value does not match the actual value, an error is returned. For descriptions about how to format
     * <code>Value</code> for different record types, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource
     * Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * You can specify more than one value for all record types except <code>CNAME</code> and <code>SOA</code>.
     * </p>
     * <note>
     * <p>
     * If you're creating an alias resource record set, omit <code>Value</code>.
     * </p>
     * </note>
     * 
     * @return The current or new DNS record value, not to exceed 4,000 characters. In the case of a <code>DELETE</code>
     *         action, if the current value does not match the actual value, an error is returned. For descriptions
     *         about how to format <code>Value</code> for different record types, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS
     *         Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         You can specify more than one value for all record types except <code>CNAME</code> and <code>SOA</code>.
     *         </p>
     *         <note>
     *         <p>
     *         If you're creating an alias resource record set, omit <code>Value</code>.
     *         </p>
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRecord)) {
            return false;
        }
        ResourceRecord other = (ResourceRecord) obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceRecord> {
        /**
         * <p>
         * The current or new DNS record value, not to exceed 4,000 characters. In the case of a <code>DELETE</code>
         * action, if the current value does not match the actual value, an error is returned. For descriptions about
         * how to format <code>Value</code> for different record types, see <a
         * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS
         * Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * You can specify more than one value for all record types except <code>CNAME</code> and <code>SOA</code>.
         * </p>
         * <note>
         * <p>
         * If you're creating an alias resource record set, omit <code>Value</code>.
         * </p>
         * </note>
         * 
         * @param value
         *        The current or new DNS record value, not to exceed 4,000 characters. In the case of a
         *        <code>DELETE</code> action, if the current value does not match the actual value, an error is
         *        returned. For descriptions about how to format <code>Value</code> for different record types, see <a
         *        href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS
         *        Resource Record Types</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        You can specify more than one value for all record types except <code>CNAME</code> and
         *        <code>SOA</code>.
         *        </p>
         *        <note>
         *        <p>
         *        If you're creating an alias resource record set, omit <code>Value</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    private static final class BuilderImpl implements Builder {
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceRecord model) {
            setValue(model.value);
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ResourceRecord build() {
            return new ResourceRecord(this);
        }
    }
}
