/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing tags for the specified resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForResourcesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTagsForResourcesResponse.Builder, ListTagsForResourcesResponse> {
    private final List<ResourceTagSet> resourceTagSets;

    private ListTagsForResourcesResponse(BuilderImpl builder) {
        this.resourceTagSets = builder.resourceTagSets;
    }

    /**
     * <p>
     * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
     * </p>
     * 
     * @return A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
     */
    public List<ResourceTagSet> resourceTagSets() {
        return resourceTagSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceTagSets() == null) ? 0 : resourceTagSets().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesResponse)) {
            return false;
        }
        ListTagsForResourcesResponse other = (ListTagsForResourcesResponse) obj;
        if (other.resourceTagSets() == null ^ this.resourceTagSets() == null) {
            return false;
        }
        if (other.resourceTagSets() != null && !other.resourceTagSets().equals(this.resourceTagSets())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceTagSets() != null) {
            sb.append("ResourceTagSets: ").append(resourceTagSets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsForResourcesResponse> {
        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * 
         * @param resourceTagSets
         *        A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets);

        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setResourceTagSets(java.util.Collection)} or {@link #withResourceTagSets(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param resourceTagSets
         *        A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSets(ResourceTagSet... resourceTagSets);
    }

    private static final class BuilderImpl implements Builder {
        private List<ResourceTagSet> resourceTagSets = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourcesResponse model) {
            setResourceTagSets(model.resourceTagSets);
        }

        public final Collection<ResourceTagSet> getResourceTagSets() {
            return resourceTagSets;
        }

        @Override
        public final Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copy(resourceTagSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagSets(ResourceTagSet... resourceTagSets) {
            if (this.resourceTagSets == null) {
                this.resourceTagSets = new SdkInternalList<>(resourceTagSets.length);
            }
            for (ResourceTagSet e : resourceTagSets) {
                this.resourceTagSets.add(e);
            }
            return this;
        }

        public final void setResourceTagSets(Collection<ResourceTagSet> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copy(resourceTagSets);
        }

        @SafeVarargs
        public final void setResourceTagSets(ResourceTagSet... resourceTagSets) {
            if (this.resourceTagSets == null) {
                this.resourceTagSets = new SdkInternalList<>(resourceTagSets.length);
            }
            for (ResourceTagSet e : resourceTagSets) {
                this.resourceTagSets.add(e);
            }
        }

        @Override
        public ListTagsForResourcesResponse build() {
            return new ListTagsForResourcesResponse(this);
        }
    }
}
