/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the health checks or hosted zones for which you want to list tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForResourceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTagsForResourceResponse.Builder, ListTagsForResourceResponse> {
    private final ResourceTagSet resourceTagSet;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        this.resourceTagSet = builder.resourceTagSet;
    }

    /**
     * <p>
     * A <code>ResourceTagSet</code> containing tags associated with the specified resource.
     * </p>
     * 
     * @return A <code>ResourceTagSet</code> containing tags associated with the specified resource.
     */
    public ResourceTagSet resourceTagSet() {
        return resourceTagSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceTagSet() == null) ? 0 : resourceTagSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse) obj;
        if (other.resourceTagSet() == null ^ this.resourceTagSet() == null) {
            return false;
        }
        if (other.resourceTagSet() != null && !other.resourceTagSet().equals(this.resourceTagSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceTagSet() != null) {
            sb.append("ResourceTagSet: ").append(resourceTagSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsForResourceResponse> {
        /**
         * <p>
         * A <code>ResourceTagSet</code> containing tags associated with the specified resource.
         * </p>
         * 
         * @param resourceTagSet
         *        A <code>ResourceTagSet</code> containing tags associated with the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSet(ResourceTagSet resourceTagSet);
    }

    private static final class BuilderImpl implements Builder {
        private ResourceTagSet resourceTagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            setResourceTagSet(model.resourceTagSet);
        }

        public final ResourceTagSet getResourceTagSet() {
            return resourceTagSet;
        }

        @Override
        public final Builder resourceTagSet(ResourceTagSet resourceTagSet) {
            this.resourceTagSet = resourceTagSet;
            return this;
        }

        public final void setResourceTagSet(ResourceTagSet resourceTagSet) {
            this.resourceTagSet = resourceTagSet;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }
    }
}
