/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains list information for the resource record set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListResourceRecordSetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListResourceRecordSetsResponse.Builder, ListResourceRecordSetsResponse> {
    private final List<ResourceRecordSet> resourceRecordSets;

    private final Boolean isTruncated;

    private final String nextRecordName;

    private final String nextRecordType;

    private final String nextRecordIdentifier;

    private final String maxItems;

    private ListResourceRecordSetsResponse(BuilderImpl builder) {
        this.resourceRecordSets = builder.resourceRecordSets;
        this.isTruncated = builder.isTruncated;
        this.nextRecordName = builder.nextRecordName;
        this.nextRecordType = builder.nextRecordType;
        this.nextRecordIdentifier = builder.nextRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * Information about multiple resource record sets.
     * </p>
     * 
     * @return Information about multiple resource record sets.
     */
    public List<ResourceRecordSet> resourceRecordSets() {
        return resourceRecordSets;
    }

    /**
     * <p>
     * A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you
     * can make a follow-up pagination request by using the <code>NextRecordName</code> element.
     * </p>
     * 
     * @return A flag that indicates whether more resource record sets remain to be listed. If your results were
     *         truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If the results were truncated, the name of the next record in the list.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is true.
     * </p>
     * 
     * @return If the results were truncated, the name of the next record in the list.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is true.
     */
    public String nextRecordName() {
        return nextRecordName;
    }

    /**
     * <p>
     * If the results were truncated, the type of the next record in the list.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is true.
     * </p>
     * 
     * @return If the results were truncated, the type of the next record in the list.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is true.
     * @see RRType
     */
    public String nextRecordType() {
        return nextRecordType;
    }

    /**
     * <p>
     * <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were truncated for a
     * given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the
     * current DNS name and type.
     * </p>
     * 
     * @return <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were truncated
     *         for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set
     *         that has the current DNS name and type.
     */
    public String nextRecordIdentifier() {
        return nextRecordIdentifier;
    }

    /**
     * <p>
     * The maximum number of records you requested.
     * </p>
     * 
     * @return The maximum number of records you requested.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceRecordSets() == null) ? 0 : resourceRecordSets().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((nextRecordName() == null) ? 0 : nextRecordName().hashCode());
        hashCode = 31 * hashCode + ((nextRecordType() == null) ? 0 : nextRecordType().hashCode());
        hashCode = 31 * hashCode + ((nextRecordIdentifier() == null) ? 0 : nextRecordIdentifier().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsResponse)) {
            return false;
        }
        ListResourceRecordSetsResponse other = (ListResourceRecordSetsResponse) obj;
        if (other.resourceRecordSets() == null ^ this.resourceRecordSets() == null) {
            return false;
        }
        if (other.resourceRecordSets() != null && !other.resourceRecordSets().equals(this.resourceRecordSets())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextRecordName() == null ^ this.nextRecordName() == null) {
            return false;
        }
        if (other.nextRecordName() != null && !other.nextRecordName().equals(this.nextRecordName())) {
            return false;
        }
        if (other.nextRecordType() == null ^ this.nextRecordType() == null) {
            return false;
        }
        if (other.nextRecordType() != null && !other.nextRecordType().equals(this.nextRecordType())) {
            return false;
        }
        if (other.nextRecordIdentifier() == null ^ this.nextRecordIdentifier() == null) {
            return false;
        }
        if (other.nextRecordIdentifier() != null && !other.nextRecordIdentifier().equals(this.nextRecordIdentifier())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceRecordSets() != null) {
            sb.append("ResourceRecordSets: ").append(resourceRecordSets()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (nextRecordName() != null) {
            sb.append("NextRecordName: ").append(nextRecordName()).append(",");
        }
        if (nextRecordType() != null) {
            sb.append("NextRecordType: ").append(nextRecordType()).append(",");
        }
        if (nextRecordIdentifier() != null) {
            sb.append("NextRecordIdentifier: ").append(nextRecordIdentifier()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListResourceRecordSetsResponse> {
        /**
         * <p>
         * Information about multiple resource record sets.
         * </p>
         * 
         * @param resourceRecordSets
         *        Information about multiple resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets);

        /**
         * <p>
         * Information about multiple resource record sets.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setResourceRecordSets(java.util.Collection)} or {@link #withResourceRecordSets(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param resourceRecordSets
         *        Information about multiple resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSets(ResourceRecordSet... resourceRecordSets);

        /**
         * <p>
         * A flag that indicates whether more resource record sets remain to be listed. If your results were truncated,
         * you can make a follow-up pagination request by using the <code>NextRecordName</code> element.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether more resource record sets remain to be listed. If your results were
         *        truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code>
         *        element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If the results were truncated, the name of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordName
         *        If the results were truncated, the name of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRecordName(String nextRecordName);

        /**
         * <p>
         * If the results were truncated, the type of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordType
         *        If the results were truncated, the type of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder nextRecordType(String nextRecordType);

        /**
         * <p>
         * If the results were truncated, the type of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordType
         *        If the results were truncated, the type of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder nextRecordType(RRType nextRecordType);

        /**
         * <p>
         * <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were truncated for
         * a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has
         * the current DNS name and type.
         * </p>
         * 
         * @param nextRecordIdentifier
         *        <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were
         *        truncated for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource
         *        record set that has the current DNS name and type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRecordIdentifier(String nextRecordIdentifier);

        /**
         * <p>
         * The maximum number of records you requested.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of records you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private List<ResourceRecordSet> resourceRecordSets = new SdkInternalList<>();

        private Boolean isTruncated;

        private String nextRecordName;

        private String nextRecordType;

        private String nextRecordIdentifier;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsResponse model) {
            setResourceRecordSets(model.resourceRecordSets);
            setIsTruncated(model.isTruncated);
            setNextRecordName(model.nextRecordName);
            setNextRecordType(model.nextRecordType);
            setNextRecordIdentifier(model.nextRecordIdentifier);
            setMaxItems(model.maxItems);
        }

        public final Collection<ResourceRecordSet> getResourceRecordSets() {
            return resourceRecordSets;
        }

        @Override
        public final Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copy(resourceRecordSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecordSets(ResourceRecordSet... resourceRecordSets) {
            if (this.resourceRecordSets == null) {
                this.resourceRecordSets = new SdkInternalList<>(resourceRecordSets.length);
            }
            for (ResourceRecordSet e : resourceRecordSets) {
                this.resourceRecordSets.add(e);
            }
            return this;
        }

        public final void setResourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copy(resourceRecordSets);
        }

        @SafeVarargs
        public final void setResourceRecordSets(ResourceRecordSet... resourceRecordSets) {
            if (this.resourceRecordSets == null) {
                this.resourceRecordSets = new SdkInternalList<>(resourceRecordSets.length);
            }
            for (ResourceRecordSet e : resourceRecordSets) {
                this.resourceRecordSets.add(e);
            }
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextRecordName() {
            return nextRecordName;
        }

        @Override
        public final Builder nextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
            return this;
        }

        public final void setNextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
        }

        public final String getNextRecordType() {
            return nextRecordType;
        }

        @Override
        public final Builder nextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
            return this;
        }

        @Override
        public final Builder nextRecordType(RRType nextRecordType) {
            this.nextRecordType(nextRecordType.toString());
            return this;
        }

        public final void setNextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
        }

        public final void setNextRecordType(RRType nextRecordType) {
            this.nextRecordType(nextRecordType.toString());
        }

        public final String getNextRecordIdentifier() {
            return nextRecordIdentifier;
        }

        @Override
        public final Builder nextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
            return this;
        }

        public final void setNextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListResourceRecordSetsResponse build() {
            return new ListResourceRecordSetsResponse(this);
        }
    }
}
