/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource record sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListGeoLocationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListGeoLocationsRequest.Builder, ListGeoLocationsRequest> {
    private final String startContinentCode;

    private final String startCountryCode;

    private final String startSubdivisionCode;

    private final String maxItems;

    private ListGeoLocationsRequest(BuilderImpl builder) {
        this.startContinentCode = builder.startContinentCode;
        this.startCountryCode = builder.startCountryCode;
        this.startSubdivisionCode = builder.startSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The code for the continent with which you want to start listing locations that Amazon Route 53 supports for
     * geolocation. If Amazon Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is
     * true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value in
     * <code>StartContinentCode</code> to return the next page of results.
     * </p>
     * <p>
     * Include <code>StartContinentCode</code> only if you want to list continents. Don't include
     * <code>StartContinentCode</code> when you're listing countries or countries with their subdivisions.
     * </p>
     * 
     * @return The code for the continent with which you want to start listing locations that Amazon Route 53 supports
     *         for geolocation. If Amazon Route 53 has already returned a page or more of results, if
     *         <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has a
     *         value, enter that value in <code>StartContinentCode</code> to return the next page of results.</p>
     *         <p>
     *         Include <code>StartContinentCode</code> only if you want to list continents. Don't include
     *         <code>StartContinentCode</code> when you're listing countries or countries with their subdivisions.
     */
    public String startContinentCode() {
        return startContinentCode;
    }

    /**
     * <p>
     * The code for the country with which you want to start listing locations that Amazon Route 53 supports for
     * geolocation. If Amazon Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is
     * <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that value
     * in <code>StartCountryCode</code> to return the next page of results.
     * </p>
     * <p>
     * Amazon Route 53 uses the two-letter country codes that are specified in <a
     * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
     * </p>
     * 
     * @return The code for the country with which you want to start listing locations that Amazon Route 53 supports for
     *         geolocation. If Amazon Route 53 has already returned a page or more of results, if
     *         <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous
     *         response has a value, enter that value in <code>StartCountryCode</code> to return the next page of
     *         results.</p>
     *         <p>
     *         Amazon Route 53 uses the two-letter country codes that are specified in <a
     *         href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
     */
    public String startCountryCode() {
        return startCountryCode;
    }

    /**
     * <p>
     * The code for the subdivision (for example, state or province) with which you want to start listing locations that
     * Amazon Route 53 supports for geolocation. If Amazon Route 53 has already returned a page or more of results, if
     * <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous response
     * has a value, enter that value in <code>StartSubdivisionCode</code> to return the next page of results.
     * </p>
     * <p>
     * To list subdivisions of a country, you must include both <code>StartCountryCode</code> and
     * <code>StartSubdivisionCode</code>.
     * </p>
     * 
     * @return The code for the subdivision (for example, state or province) with which you want to start listing
     *         locations that Amazon Route 53 supports for geolocation. If Amazon Route 53 has already returned a page
     *         or more of results, if <code>IsTruncated</code> is <code>true</code>, and if
     *         <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in
     *         <code>StartSubdivisionCode</code> to return the next page of results.</p>
     *         <p>
     *         To list subdivisions of a country, you must include both <code>StartCountryCode</code> and
     *         <code>StartSubdivisionCode</code>.
     */
    public String startSubdivisionCode() {
        return startSubdivisionCode;
    }

    /**
     * <p>
     * (Optional) The maximum number of geolocations to be included in the response body for this request. If more than
     * <code>MaxItems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in
     * the response is <code>true</code>.
     * </p>
     * 
     * @return (Optional) The maximum number of geolocations to be included in the response body for this request. If
     *         more than <code>MaxItems</code> geolocations remain to be listed, then the value of the
     *         <code>IsTruncated</code> element in the response is <code>true</code>.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((startContinentCode() == null) ? 0 : startContinentCode().hashCode());
        hashCode = 31 * hashCode + ((startCountryCode() == null) ? 0 : startCountryCode().hashCode());
        hashCode = 31 * hashCode + ((startSubdivisionCode() == null) ? 0 : startSubdivisionCode().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsRequest)) {
            return false;
        }
        ListGeoLocationsRequest other = (ListGeoLocationsRequest) obj;
        if (other.startContinentCode() == null ^ this.startContinentCode() == null) {
            return false;
        }
        if (other.startContinentCode() != null && !other.startContinentCode().equals(this.startContinentCode())) {
            return false;
        }
        if (other.startCountryCode() == null ^ this.startCountryCode() == null) {
            return false;
        }
        if (other.startCountryCode() != null && !other.startCountryCode().equals(this.startCountryCode())) {
            return false;
        }
        if (other.startSubdivisionCode() == null ^ this.startSubdivisionCode() == null) {
            return false;
        }
        if (other.startSubdivisionCode() != null && !other.startSubdivisionCode().equals(this.startSubdivisionCode())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (startContinentCode() != null) {
            sb.append("StartContinentCode: ").append(startContinentCode()).append(",");
        }
        if (startCountryCode() != null) {
            sb.append("StartCountryCode: ").append(startCountryCode()).append(",");
        }
        if (startSubdivisionCode() != null) {
            sb.append("StartSubdivisionCode: ").append(startSubdivisionCode()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListGeoLocationsRequest> {
        /**
         * <p>
         * The code for the continent with which you want to start listing locations that Amazon Route 53 supports for
         * geolocation. If Amazon Route 53 has already returned a page or more of results, if <code>IsTruncated</code>
         * is true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value in
         * <code>StartContinentCode</code> to return the next page of results.
         * </p>
         * <p>
         * Include <code>StartContinentCode</code> only if you want to list continents. Don't include
         * <code>StartContinentCode</code> when you're listing countries or countries with their subdivisions.
         * </p>
         * 
         * @param startContinentCode
         *        The code for the continent with which you want to start listing locations that Amazon Route 53
         *        supports for geolocation. If Amazon Route 53 has already returned a page or more of results, if
         *        <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has
         *        a value, enter that value in <code>StartContinentCode</code> to return the next page of results.</p>
         *        <p>
         *        Include <code>StartContinentCode</code> only if you want to list continents. Don't include
         *        <code>StartContinentCode</code> when you're listing countries or countries with their subdivisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startContinentCode(String startContinentCode);

        /**
         * <p>
         * The code for the country with which you want to start listing locations that Amazon Route 53 supports for
         * geolocation. If Amazon Route 53 has already returned a page or more of results, if <code>IsTruncated</code>
         * is <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that
         * value in <code>StartCountryCode</code> to return the next page of results.
         * </p>
         * <p>
         * Amazon Route 53 uses the two-letter country codes that are specified in <a
         * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
         * </p>
         * 
         * @param startCountryCode
         *        The code for the country with which you want to start listing locations that Amazon Route 53 supports
         *        for geolocation. If Amazon Route 53 has already returned a page or more of results, if
         *        <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous
         *        response has a value, enter that value in <code>StartCountryCode</code> to return the next page of
         *        results.</p>
         *        <p>
         *        Amazon Route 53 uses the two-letter country codes that are specified in <a
         *        href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startCountryCode(String startCountryCode);

        /**
         * <p>
         * The code for the subdivision (for example, state or province) with which you want to start listing locations
         * that Amazon Route 53 supports for geolocation. If Amazon Route 53 has already returned a page or more of
         * results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the
         * previous response has a value, enter that value in <code>StartSubdivisionCode</code> to return the next page
         * of results.
         * </p>
         * <p>
         * To list subdivisions of a country, you must include both <code>StartCountryCode</code> and
         * <code>StartSubdivisionCode</code>.
         * </p>
         * 
         * @param startSubdivisionCode
         *        The code for the subdivision (for example, state or province) with which you want to start listing
         *        locations that Amazon Route 53 supports for geolocation. If Amazon Route 53 has already returned a
         *        page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if
         *        <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in
         *        <code>StartSubdivisionCode</code> to return the next page of results.</p>
         *        <p>
         *        To list subdivisions of a country, you must include both <code>StartCountryCode</code> and
         *        <code>StartSubdivisionCode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startSubdivisionCode(String startSubdivisionCode);

        /**
         * <p>
         * (Optional) The maximum number of geolocations to be included in the response body for this request. If more
         * than <code>MaxItems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code>
         * element in the response is <code>true</code>.
         * </p>
         * 
         * @param maxItems
         *        (Optional) The maximum number of geolocations to be included in the response body for this request. If
         *        more than <code>MaxItems</code> geolocations remain to be listed, then the value of the
         *        <code>IsTruncated</code> element in the response is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private String startContinentCode;

        private String startCountryCode;

        private String startSubdivisionCode;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsRequest model) {
            setStartContinentCode(model.startContinentCode);
            setStartCountryCode(model.startCountryCode);
            setStartSubdivisionCode(model.startSubdivisionCode);
            setMaxItems(model.maxItems);
        }

        public final String getStartContinentCode() {
            return startContinentCode;
        }

        @Override
        public final Builder startContinentCode(String startContinentCode) {
            this.startContinentCode = startContinentCode;
            return this;
        }

        public final void setStartContinentCode(String startContinentCode) {
            this.startContinentCode = startContinentCode;
        }

        public final String getStartCountryCode() {
            return startCountryCode;
        }

        @Override
        public final Builder startCountryCode(String startCountryCode) {
            this.startCountryCode = startCountryCode;
            return this;
        }

        public final void setStartCountryCode(String startCountryCode) {
            this.startCountryCode = startCountryCode;
        }

        public final String getStartSubdivisionCode() {
            return startSubdivisionCode;
        }

        @Override
        public final Builder startSubdivisionCode(String startSubdivisionCode) {
            this.startSubdivisionCode = startSubdivisionCode;
            return this;
        }

        public final void setStartSubdivisionCode(String startSubdivisionCode) {
            this.startSubdivisionCode = startSubdivisionCode;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListGeoLocationsRequest build() {
            return new ListGeoLocationsRequest(this);
        }
    }
}
