/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information from a <code>CreateVPCAssociationAuthorization</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVPCAssociationAuthorizationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateVPCAssociationAuthorizationResponse.Builder, CreateVPCAssociationAuthorizationResponse> {
    private final String hostedZoneId;

    private final VPC vpc;

    private CreateVPCAssociationAuthorizationResponse(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The ID of the hosted zone that you authorized associating a VPC with.
     * </p>
     * 
     * @return The ID of the hosted zone that you authorized associating a VPC with.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The VPC that you authorized associating with a hosted zone.
     * </p>
     * 
     * @return The VPC that you authorized associating with a hosted zone.
     */
    public VPC vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZoneId() == null) ? 0 : hostedZoneId().hashCode());
        hashCode = 31 * hashCode + ((vpc() == null) ? 0 : vpc().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVPCAssociationAuthorizationResponse)) {
            return false;
        }
        CreateVPCAssociationAuthorizationResponse other = (CreateVPCAssociationAuthorizationResponse) obj;
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.vpc() == null ^ this.vpc() == null) {
            return false;
        }
        if (other.vpc() != null && !other.vpc().equals(this.vpc())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (vpc() != null) {
            sb.append("VPC: ").append(vpc()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVPCAssociationAuthorizationResponse> {
        /**
         * <p>
         * The ID of the hosted zone that you authorized associating a VPC with.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you authorized associating a VPC with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The VPC that you authorized associating with a hosted zone.
         * </p>
         * 
         * @param vpc
         *        The VPC that you authorized associating with a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);
    }

    private static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private VPC vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVPCAssociationAuthorizationResponse model) {
            setHostedZoneId(model.hostedZoneId);
            setVPC(model.vpc);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final VPC getVPC() {
            return vpc;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC vpc) {
            this.vpc = vpc;
        }

        @Override
        public CreateVPCAssociationAuthorizationResponse build() {
            return new CreateVPCAssociationAuthorizationResponse(this);
        }
    }
}
