/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains change information for the resource record set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeResourceRecordSetsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ChangeResourceRecordSetsRequest.Builder, ChangeResourceRecordSetsRequest> {
    private final String hostedZoneId;

    private final ChangeBatch changeBatch;

    private ChangeResourceRecordSetsRequest(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.changeBatch = builder.changeBatch;
    }

    /**
     * <p>
     * The ID of the hosted zone that contains the resource record sets that you want to change.
     * </p>
     * 
     * @return The ID of the hosted zone that contains the resource record sets that you want to change.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * A complex type that contains an optional comment and the <code>Changes</code> element.
     * </p>
     * 
     * @return A complex type that contains an optional comment and the <code>Changes</code> element.
     */
    public ChangeBatch changeBatch() {
        return changeBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZoneId() == null) ? 0 : hostedZoneId().hashCode());
        hashCode = 31 * hashCode + ((changeBatch() == null) ? 0 : changeBatch().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeResourceRecordSetsRequest)) {
            return false;
        }
        ChangeResourceRecordSetsRequest other = (ChangeResourceRecordSetsRequest) obj;
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.changeBatch() == null ^ this.changeBatch() == null) {
            return false;
        }
        if (other.changeBatch() != null && !other.changeBatch().equals(this.changeBatch())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (changeBatch() != null) {
            sb.append("ChangeBatch: ").append(changeBatch()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeResourceRecordSetsRequest> {
        /**
         * <p>
         * The ID of the hosted zone that contains the resource record sets that you want to change.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that contains the resource record sets that you want to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * A complex type that contains an optional comment and the <code>Changes</code> element.
         * </p>
         * 
         * @param changeBatch
         *        A complex type that contains an optional comment and the <code>Changes</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeBatch(ChangeBatch changeBatch);
    }

    private static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private ChangeBatch changeBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeResourceRecordSetsRequest model) {
            setHostedZoneId(model.hostedZoneId);
            setChangeBatch(model.changeBatch);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final ChangeBatch getChangeBatch() {
            return changeBatch;
        }

        @Override
        public final Builder changeBatch(ChangeBatch changeBatch) {
            this.changeBatch = changeBatch;
            return this;
        }

        public final void setChangeBatch(ChangeBatch changeBatch) {
            this.changeBatch = changeBatch;
        }

        @Override
        public ChangeResourceRecordSetsRequest build() {
            return new ChangeResourceRecordSetsRequest(this);
        }
    }
}
