/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine
 * whether this health check is healthy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AlarmIdentifier implements ToCopyableBuilder<AlarmIdentifier.Builder, AlarmIdentifier> {
    private final String region;

    private final String name;

    private AlarmIdentifier(BuilderImpl builder) {
        this.region = builder.region;
        this.name = builder.name;
    }

    /**
     * <p>
     * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to
     * determine whether this health check is healthy.
     * </p>
     * <p>
     * For the current list of CloudWatch regions, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region">Amazon CloudWatch</a> in the <i>AWS
     * Regions and Endpoints</i> chapter of the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use
     *         to determine whether this health check is healthy.</p>
     *         <p>
     *         For the current list of CloudWatch regions, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region">Amazon CloudWatch</a> in the
     *         <i>AWS Regions and Endpoints</i> chapter of the <i>Amazon Web Services General Reference</i>.
     * @see CloudWatchRegion
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this
     * health check is healthy.
     * </p>
     * 
     * @return The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine
     *         whether this health check is healthy.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((region() == null) ? 0 : region().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmIdentifier)) {
            return false;
        }
        AlarmIdentifier other = (AlarmIdentifier) obj;
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (region() != null) {
            sb.append("Region: ").append(region()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AlarmIdentifier> {
        /**
         * <p>
         * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to
         * determine whether this health check is healthy.
         * </p>
         * <p>
         * For the current list of CloudWatch regions, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region">Amazon CloudWatch</a> in the <i>AWS
         * Regions and Endpoints</i> chapter of the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param region
         *        A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to
         *        use to determine whether this health check is healthy.</p>
         *        <p>
         *        For the current list of CloudWatch regions, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region">Amazon CloudWatch</a> in the
         *        <i>AWS Regions and Endpoints</i> chapter of the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchRegion
         */
        Builder region(String region);

        /**
         * <p>
         * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to
         * determine whether this health check is healthy.
         * </p>
         * <p>
         * For the current list of CloudWatch regions, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region">Amazon CloudWatch</a> in the <i>AWS
         * Regions and Endpoints</i> chapter of the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param region
         *        A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to
         *        use to determine whether this health check is healthy.</p>
         *        <p>
         *        For the current list of CloudWatch regions, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region">Amazon CloudWatch</a> in the
         *        <i>AWS Regions and Endpoints</i> chapter of the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchRegion
         */
        Builder region(CloudWatchRegion region);

        /**
         * <p>
         * The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether
         * this health check is healthy.
         * </p>
         * 
         * @param name
         *        The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine
         *        whether this health check is healthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    private static final class BuilderImpl implements Builder {
        private String region;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmIdentifier model) {
            setRegion(model.region);
            setName(model.name);
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(CloudWatchRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final void setRegion(CloudWatchRegion region) {
            this.region(region.toString());
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public AlarmIdentifier build() {
            return new AlarmIdentifier(this);
        }
    }
}
