/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.services.rolesanywhere.model.Tag;
import software.amazon.awssdk.services.rolesanywhere.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportCrlRequest
extends RolesAnywhereRequest
implements ToCopyableBuilder<Builder, ImportCrlRequest> {
    private static final SdkField<SdkBytes> CRL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("crlData").getter(ImportCrlRequest.getter(ImportCrlRequest::crlData)).setter(ImportCrlRequest.setter(Builder::crlData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlData").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(ImportCrlRequest.getter(ImportCrlRequest::enabled)).setter(ImportCrlRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ImportCrlRequest.getter(ImportCrlRequest::name)).setter(ImportCrlRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(ImportCrlRequest.getter(ImportCrlRequest::tags)).setter(ImportCrlRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRUST_ANCHOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustAnchorArn").getter(ImportCrlRequest.getter(ImportCrlRequest::trustAnchorArn)).setter(ImportCrlRequest.setter(Builder::trustAnchorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRL_DATA_FIELD, ENABLED_FIELD, NAME_FIELD, TAGS_FIELD, TRUST_ANCHOR_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportCrlRequest.memberNameToFieldInitializer();
    private final SdkBytes crlData;
    private final Boolean enabled;
    private final String name;
    private final List<Tag> tags;
    private final String trustAnchorArn;

    private ImportCrlRequest(BuilderImpl builder) {
        super(builder);
        this.crlData = builder.crlData;
        this.enabled = builder.enabled;
        this.name = builder.name;
        this.tags = builder.tags;
        this.trustAnchorArn = builder.trustAnchorArn;
    }

    public final SdkBytes crlData() {
        return this.crlData;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String trustAnchorArn() {
        return this.trustAnchorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.crlData());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchorArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCrlRequest)) {
            return false;
        }
        ImportCrlRequest other = (ImportCrlRequest)((Object)obj);
        return Objects.equals(this.crlData(), other.crlData()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.trustAnchorArn(), other.trustAnchorArn());
    }

    public final String toString() {
        return ToString.builder((String)"ImportCrlRequest").add("CrlData", (Object)this.crlData()).add("Enabled", (Object)this.enabled()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("TrustAnchorArn", (Object)this.trustAnchorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crlData": {
                return Optional.ofNullable(clazz.cast(this.crlData()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "trustAnchorArn": {
                return Optional.ofNullable(clazz.cast(this.trustAnchorArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("crlData", CRL_DATA_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("trustAnchorArn", TRUST_ANCHOR_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportCrlRequest, T> g) {
        return obj -> g.apply((ImportCrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereRequest.BuilderImpl
    implements Builder {
        private SdkBytes crlData;
        private Boolean enabled;
        private String name;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String trustAnchorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCrlRequest model) {
            super(model);
            this.crlData(model.crlData);
            this.enabled(model.enabled);
            this.name(model.name);
            this.tags(model.tags);
            this.trustAnchorArn(model.trustAnchorArn);
        }

        public final ByteBuffer getCrlData() {
            return this.crlData == null ? null : this.crlData.asByteBuffer();
        }

        public final void setCrlData(ByteBuffer crlData) {
            this.crlData(crlData == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)crlData));
        }

        @Override
        public final Builder crlData(SdkBytes crlData) {
            this.crlData = crlData;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrustAnchorArn() {
            return this.trustAnchorArn;
        }

        public final void setTrustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
        }

        @Override
        public final Builder trustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCrlRequest build() {
            return new ImportCrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RolesAnywhereRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportCrlRequest> {
        public Builder crlData(SdkBytes var1);

        public Builder enabled(Boolean var1);

        public Builder name(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder trustAnchorArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

