/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfilesResponse extends RolesAnywhereResponse implements
        ToCopyableBuilder<ListProfilesResponse.Builder, ListProfilesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ProfileDetail>> PROFILES_FIELD = SdkField
            .<List<ProfileDetail>> builder(MarshallingType.LIST)
            .memberName("profiles")
            .getter(getter(ListProfilesResponse::profiles))
            .setter(setter(Builder::profiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROFILES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ProfileDetail> profiles;

    private ListProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.profiles = builder.profiles;
    }

    /**
     * <p>
     * A token that indicates where the output should continue from, if a previous request did not show all results. To
     * get the next results, make the request again with this value.
     * </p>
     * 
     * @return A token that indicates where the output should continue from, if a previous request did not show all
     *         results. To get the next results, make the request again with this value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Profiles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return A list of profiles.
     */
    public final List<ProfileDetail> profiles() {
        return profiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profiles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilesResponse)) {
            return false;
        }
        ListProfilesResponse other = (ListProfilesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasProfiles() == other.hasProfiles()
                && Objects.equals(profiles(), other.profiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfilesResponse").add("NextToken", nextToken())
                .add("Profiles", hasProfiles() ? profiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "profiles":
            return Optional.ofNullable(clazz.cast(profiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("profiles", PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfilesResponse, T> g) {
        return obj -> g.apply((ListProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProfilesResponse> {
        /**
         * <p>
         * A token that indicates where the output should continue from, if a previous request did not show all results.
         * To get the next results, make the request again with this value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where the output should continue from, if a previous request did not show all
         *        results. To get the next results, make the request again with this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of profiles.
         * </p>
         * 
         * @param profiles
         *        A list of profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Collection<ProfileDetail> profiles);

        /**
         * <p>
         * A list of profiles.
         * </p>
         * 
         * @param profiles
         *        A list of profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(ProfileDetail... profiles);

        /**
         * <p>
         * A list of profiles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.ProfileDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rolesanywhere.model.ProfileDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.ProfileDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #profiles(List<ProfileDetail>)}.
         * 
         * @param profiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.ProfileDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profiles(java.util.Collection<ProfileDetail>)
         */
        Builder profiles(Consumer<ProfileDetail.Builder>... profiles);
    }

    static final class BuilderImpl extends RolesAnywhereResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ProfileDetail> profiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilesResponse model) {
            super(model);
            nextToken(model.nextToken);
            profiles(model.profiles);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProfileDetail.Builder> getProfiles() {
            List<ProfileDetail.Builder> result = ProfileDetailsCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<ProfileDetail.BuilderImpl> profiles) {
            this.profiles = ProfileDetailsCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<ProfileDetail> profiles) {
            this.profiles = ProfileDetailsCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(ProfileDetail... profiles) {
            profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<ProfileDetail.Builder>... profiles) {
            profiles(Stream.of(profiles).map(c -> ProfileDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProfilesResponse build() {
            return new ListProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
