/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereAsyncClient;
import software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.SubjectSummary;

public class ListSubjectsPublisher
implements SdkPublisher<ListSubjectsResponse> {
    private final RolesAnywhereAsyncClient client;
    private final ListSubjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubjectsPublisher(RolesAnywhereAsyncClient client, ListSubjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubjectsPublisher(RolesAnywhereAsyncClient client, ListSubjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SubjectSummary> subjects() {
        Function<ListSubjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subjects() != null) {
                return response.subjects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSubjectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubjectsResponseFetcher
    implements AsyncPageFetcher<ListSubjectsResponse> {
        private ListSubjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubjectsResponse> nextPage(ListSubjectsResponse previousPage) {
            if (previousPage == null) {
                return ListSubjectsPublisher.this.client.listSubjects(ListSubjectsPublisher.this.firstRequest);
            }
            return ListSubjectsPublisher.this.client.listSubjects((ListSubjectsRequest)((Object)ListSubjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

