/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class NotificationSettingKeysCopier {
    static List<NotificationSettingKey> copy(Collection<? extends NotificationSettingKey> notificationSettingKeysParam) {
        List<NotificationSettingKey> list;
        if (notificationSettingKeysParam == null || notificationSettingKeysParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<NotificationSettingKey> modifiableList = new ArrayList<>();
            notificationSettingKeysParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<NotificationSettingKey> copyFromBuilder(
            Collection<? extends NotificationSettingKey.Builder> notificationSettingKeysParam) {
        List<NotificationSettingKey> list;
        if (notificationSettingKeysParam == null || notificationSettingKeysParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<NotificationSettingKey> modifiableList = new ArrayList<>();
            notificationSettingKeysParam.forEach(entry -> {
                NotificationSettingKey member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<NotificationSettingKey.Builder> copyToBuilder(
            Collection<? extends NotificationSettingKey> notificationSettingKeysParam) {
        List<NotificationSettingKey.Builder> list;
        if (notificationSettingKeysParam == null || notificationSettingKeysParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<NotificationSettingKey.Builder> modifiableList = new ArrayList<>();
            notificationSettingKeysParam.forEach(entry -> {
                NotificationSettingKey.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
