/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSubjectRequest extends RolesAnywhereRequest implements
        ToCopyableBuilder<GetSubjectRequest.Builder, GetSubjectRequest> {
    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectId").getter(getter(GetSubjectRequest::subjectId)).setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("subjectId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_ID_FIELD));

    private final String subjectId;

    private GetSubjectRequest(BuilderImpl builder) {
        super(builder);
        this.subjectId = builder.subjectId;
    }

    /**
     * <p>
     * The unique identifier of the subject.
     * </p>
     * 
     * @return The unique identifier of the subject.
     */
    public final String subjectId() {
        return subjectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubjectRequest)) {
            return false;
        }
        GetSubjectRequest other = (GetSubjectRequest) obj;
        return Objects.equals(subjectId(), other.subjectId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSubjectRequest").add("SubjectId", subjectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSubjectRequest, T> g) {
        return obj -> g.apply((GetSubjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSubjectRequest> {
        /**
         * <p>
         * The unique identifier of the subject.
         * </p>
         * 
         * @param subjectId
         *        The unique identifier of the subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RolesAnywhereRequest.BuilderImpl implements Builder {
        private String subjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubjectRequest model) {
            super(model);
            subjectId(model.subjectId);
        }

        public final String getSubjectId() {
            return subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSubjectRequest build() {
            return new GetSubjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
