/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of the profile after a read or write operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileDetail implements SdkPojo, Serializable, ToCopyableBuilder<ProfileDetail.Builder, ProfileDetail> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ProfileDetail::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(ProfileDetail::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("durationSeconds").getter(getter(ProfileDetail::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(ProfileDetail::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<List<String>> MANAGED_POLICY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managedPolicyArns")
            .getter(getter(ProfileDetail::managedPolicyArns))
            .setter(setter(Builder::managedPolicyArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedPolicyArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ProfileDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileArn").getter(getter(ProfileDetail::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileArn").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(ProfileDetail::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()).build();

    private static final SdkField<Boolean> REQUIRE_INSTANCE_PROPERTIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("requireInstanceProperties")
            .getter(getter(ProfileDetail::requireInstanceProperties)).setter(setter(Builder::requireInstanceProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requireInstanceProperties").build())
            .build();

    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("roleArns")
            .getter(getter(ProfileDetail::roleArns))
            .setter(setter(Builder::roleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SESSION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionPolicy").getter(getter(ProfileDetail::sessionPolicy)).setter(setter(Builder::sessionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionPolicy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(ProfileDetail::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DURATION_SECONDS_FIELD, ENABLED_FIELD, MANAGED_POLICY_ARNS_FIELD, NAME_FIELD, PROFILE_ARN_FIELD,
            PROFILE_ID_FIELD, REQUIRE_INSTANCE_PROPERTIES_FIELD, ROLE_ARNS_FIELD, SESSION_POLICY_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final Integer durationSeconds;

    private final Boolean enabled;

    private final List<String> managedPolicyArns;

    private final String name;

    private final String profileArn;

    private final String profileId;

    private final Boolean requireInstanceProperties;

    private final List<String> roleArns;

    private final String sessionPolicy;

    private final Instant updatedAt;

    private ProfileDetail(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.durationSeconds = builder.durationSeconds;
        this.enabled = builder.enabled;
        this.managedPolicyArns = builder.managedPolicyArns;
        this.name = builder.name;
        this.profileArn = builder.profileArn;
        this.profileId = builder.profileId;
        this.requireInstanceProperties = builder.requireInstanceProperties;
        this.roleArns = builder.roleArns;
        this.sessionPolicy = builder.sessionPolicy;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the profile was created.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the profile was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Web Services account that created the profile.
     * </p>
     * 
     * @return The Amazon Web Services account that created the profile.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The number of seconds the vended session credentials are valid for.
     * </p>
     * 
     * @return The number of seconds the vended session credentials are valid for.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * Indicates whether the profile is enabled.
     * </p>
     * 
     * @return Indicates whether the profile is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedPolicyArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedPolicyArns() {
        return managedPolicyArns != null && !(managedPolicyArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of managed policy ARNs that apply to the vended session credentials.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedPolicyArns} method.
     * </p>
     * 
     * @return A list of managed policy ARNs that apply to the vended session credentials.
     */
    public final List<String> managedPolicyArns() {
        return managedPolicyArns;
    }

    /**
     * <p>
     * The name of the profile.
     * </p>
     * 
     * @return The name of the profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the profile.
     * </p>
     * 
     * @return The ARN of the profile.
     */
    public final String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The unique identifier of the profile.
     * </p>
     * 
     * @return The unique identifier of the profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Specifies whether instance properties are required in <a
     * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
     * requests with this profile.
     * </p>
     * 
     * @return Specifies whether instance properties are required in <a
     *         href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html"
     *         >CreateSession</a> requests with this profile.
     */
    public final Boolean requireInstanceProperties() {
        return requireInstanceProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoleArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoleArns() {
        return roleArns != null && !(roleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM roles that this profile can assume in a <a
     * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
     * operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoleArns} method.
     * </p>
     * 
     * @return A list of IAM roles that this profile can assume in a <a
     *         href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html"
     *         >CreateSession</a> operation.
     */
    public final List<String> roleArns() {
        return roleArns;
    }

    /**
     * <p>
     * A session policy that applies to the trust boundary of the vended session credentials.
     * </p>
     * 
     * @return A session policy that applies to the trust boundary of the vended session credentials.
     */
    public final String sessionPolicy() {
        return sessionPolicy;
    }

    /**
     * <p>
     * The ISO-8601 timestamp when the profile was last updated.
     * </p>
     * 
     * @return The ISO-8601 timestamp when the profile was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedPolicyArns() ? managedPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(requireInstanceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoleArns() ? roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileDetail)) {
            return false;
        }
        ProfileDetail other = (ProfileDetail) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(durationSeconds(), other.durationSeconds()) && Objects.equals(enabled(), other.enabled())
                && hasManagedPolicyArns() == other.hasManagedPolicyArns()
                && Objects.equals(managedPolicyArns(), other.managedPolicyArns()) && Objects.equals(name(), other.name())
                && Objects.equals(profileArn(), other.profileArn()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(requireInstanceProperties(), other.requireInstanceProperties())
                && hasRoleArns() == other.hasRoleArns() && Objects.equals(roleArns(), other.roleArns())
                && Objects.equals(sessionPolicy(), other.sessionPolicy()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileDetail").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("DurationSeconds", durationSeconds()).add("Enabled", enabled())
                .add("ManagedPolicyArns", hasManagedPolicyArns() ? managedPolicyArns() : null).add("Name", name())
                .add("ProfileArn", profileArn()).add("ProfileId", profileId())
                .add("RequireInstanceProperties", requireInstanceProperties()).add("RoleArns", hasRoleArns() ? roleArns() : null)
                .add("SessionPolicy", sessionPolicy()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "durationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "managedPolicyArns":
            return Optional.ofNullable(clazz.cast(managedPolicyArns()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "profileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "requireInstanceProperties":
            return Optional.ofNullable(clazz.cast(requireInstanceProperties()));
        case "roleArns":
            return Optional.ofNullable(clazz.cast(roleArns()));
        case "sessionPolicy":
            return Optional.ofNullable(clazz.cast(sessionPolicy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileDetail, T> g) {
        return obj -> g.apply((ProfileDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileDetail> {
        /**
         * <p>
         * The ISO-8601 timestamp when the profile was created.
         * </p>
         * 
         * @param createdAt
         *        The ISO-8601 timestamp when the profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Web Services account that created the profile.
         * </p>
         * 
         * @param createdBy
         *        The Amazon Web Services account that created the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The number of seconds the vended session credentials are valid for.
         * </p>
         * 
         * @param durationSeconds
         *        The number of seconds the vended session credentials are valid for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * Indicates whether the profile is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the profile is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A list of managed policy ARNs that apply to the vended session credentials.
         * </p>
         * 
         * @param managedPolicyArns
         *        A list of managed policy ARNs that apply to the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPolicyArns(Collection<String> managedPolicyArns);

        /**
         * <p>
         * A list of managed policy ARNs that apply to the vended session credentials.
         * </p>
         * 
         * @param managedPolicyArns
         *        A list of managed policy ARNs that apply to the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPolicyArns(String... managedPolicyArns);

        /**
         * <p>
         * The name of the profile.
         * </p>
         * 
         * @param name
         *        The name of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the profile.
         * </p>
         * 
         * @param profileArn
         *        The ARN of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The unique identifier of the profile.
         * </p>
         * 
         * @param profileId
         *        The unique identifier of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Specifies whether instance properties are required in <a
         * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
         * requests with this profile.
         * </p>
         * 
         * @param requireInstanceProperties
         *        Specifies whether instance properties are required in <a
         *        href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html"
         *        >CreateSession</a> requests with this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireInstanceProperties(Boolean requireInstanceProperties);

        /**
         * <p>
         * A list of IAM roles that this profile can assume in a <a
         * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
         * operation.
         * </p>
         * 
         * @param roleArns
         *        A list of IAM roles that this profile can assume in a <a
         *        href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html"
         *        >CreateSession</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(Collection<String> roleArns);

        /**
         * <p>
         * A list of IAM roles that this profile can assume in a <a
         * href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html">CreateSession</a>
         * operation.
         * </p>
         * 
         * @param roleArns
         *        A list of IAM roles that this profile can assume in a <a
         *        href="https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html"
         *        >CreateSession</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(String... roleArns);

        /**
         * <p>
         * A session policy that applies to the trust boundary of the vended session credentials.
         * </p>
         * 
         * @param sessionPolicy
         *        A session policy that applies to the trust boundary of the vended session credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionPolicy(String sessionPolicy);

        /**
         * <p>
         * The ISO-8601 timestamp when the profile was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The ISO-8601 timestamp when the profile was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private Integer durationSeconds;

        private Boolean enabled;

        private List<String> managedPolicyArns = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String profileArn;

        private String profileId;

        private Boolean requireInstanceProperties;

        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();

        private String sessionPolicy;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileDetail model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            durationSeconds(model.durationSeconds);
            enabled(model.enabled);
            managedPolicyArns(model.managedPolicyArns);
            name(model.name);
            profileArn(model.profileArn);
            profileId(model.profileId);
            requireInstanceProperties(model.requireInstanceProperties);
            roleArns(model.roleArns);
            sessionPolicy(model.sessionPolicy);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Collection<String> getManagedPolicyArns() {
            if (managedPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return managedPolicyArns;
        }

        public final void setManagedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
        }

        @Override
        public final Builder managedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedPolicyArns(String... managedPolicyArns) {
            managedPolicyArns(Arrays.asList(managedPolicyArns));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final Boolean getRequireInstanceProperties() {
            return requireInstanceProperties;
        }

        public final void setRequireInstanceProperties(Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
        }

        @Override
        public final Builder requireInstanceProperties(Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
            return this;
        }

        public final Collection<String> getRoleArns() {
            if (roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return roleArns;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
        }

        @Override
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleArns(String... roleArns) {
            roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final String getSessionPolicy() {
            return sessionPolicy;
        }

        public final void setSessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
        }

        @Override
        public final Builder sessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ProfileDetail build() {
            return new ProfileDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
