/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.S3EtagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRobotApplicationVersionRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateRobotApplicationVersionRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(CreateRobotApplicationVersionRequest.getter(CreateRobotApplicationVersionRequest::application)).setter(CreateRobotApplicationVersionRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<String> CURRENT_REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentRevisionId").getter(CreateRobotApplicationVersionRequest.getter(CreateRobotApplicationVersionRequest::currentRevisionId)).setter(CreateRobotApplicationVersionRequest.setter(Builder::currentRevisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevisionId").build()}).build();
    private static final SdkField<List<String>> S3_ETAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3Etags").getter(CreateRobotApplicationVersionRequest.getter(CreateRobotApplicationVersionRequest::s3Etags)).setter(CreateRobotApplicationVersionRequest.setter(Builder::s3Etags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Etags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(CreateRobotApplicationVersionRequest.getter(CreateRobotApplicationVersionRequest::imageDigest)).setter(CreateRobotApplicationVersionRequest.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, CURRENT_REVISION_ID_FIELD, S3_ETAGS_FIELD, IMAGE_DIGEST_FIELD));
    private final String application;
    private final String currentRevisionId;
    private final List<String> s3Etags;
    private final String imageDigest;

    private CreateRobotApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.currentRevisionId = builder.currentRevisionId;
        this.s3Etags = builder.s3Etags;
        this.imageDigest = builder.imageDigest;
    }

    public final String application() {
        return this.application;
    }

    public final String currentRevisionId() {
        return this.currentRevisionId;
    }

    public final boolean hasS3Etags() {
        return this.s3Etags != null && !(this.s3Etags instanceof SdkAutoConstructList);
    }

    public final List<String> s3Etags() {
        return this.s3Etags;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Etags() ? this.s3Etags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRobotApplicationVersionRequest)) {
            return false;
        }
        CreateRobotApplicationVersionRequest other = (CreateRobotApplicationVersionRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.currentRevisionId(), other.currentRevisionId()) && this.hasS3Etags() == other.hasS3Etags() && Objects.equals(this.s3Etags(), other.s3Etags()) && Objects.equals(this.imageDigest(), other.imageDigest());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRobotApplicationVersionRequest").add("Application", (Object)this.application()).add("CurrentRevisionId", (Object)this.currentRevisionId()).add("S3Etags", this.hasS3Etags() ? this.s3Etags() : null).add("ImageDigest", (Object)this.imageDigest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "currentRevisionId": {
                return Optional.ofNullable(clazz.cast(this.currentRevisionId()));
            }
            case "s3Etags": {
                return Optional.ofNullable(clazz.cast(this.s3Etags()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRobotApplicationVersionRequest, T> g) {
        return obj -> g.apply((CreateRobotApplicationVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String application;
        private String currentRevisionId;
        private List<String> s3Etags = DefaultSdkAutoConstructList.getInstance();
        private String imageDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRobotApplicationVersionRequest model) {
            super(model);
            this.application(model.application);
            this.currentRevisionId(model.currentRevisionId);
            this.s3Etags(model.s3Etags);
            this.imageDigest(model.imageDigest);
        }

        public final String getApplication() {
            return this.application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getCurrentRevisionId() {
            return this.currentRevisionId;
        }

        public final void setCurrentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
        }

        @Override
        public final Builder currentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        public final Collection<String> getS3Etags() {
            if (this.s3Etags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3Etags;
        }

        public final void setS3Etags(Collection<String> s3Etags) {
            this.s3Etags = S3EtagsCopier.copy(s3Etags);
        }

        @Override
        public final Builder s3Etags(Collection<String> s3Etags) {
            this.s3Etags = S3EtagsCopier.copy(s3Etags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Etags(String ... s3Etags) {
            this.s3Etags(Arrays.asList(s3Etags));
            return this;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRobotApplicationVersionRequest build() {
            return new CreateRobotApplicationVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRobotApplicationVersionRequest> {
        public Builder application(String var1);

        public Builder currentRevisionId(String var1);

        public Builder s3Etags(Collection<String> var1);

        public Builder s3Etags(String ... var1);

        public Builder imageDigest(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

