/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RobotStatus {
    AVAILABLE("Available"),
    REGISTERED("Registered"),
    PENDING_NEW_DEPLOYMENT("PendingNewDeployment"),
    DEPLOYING("Deploying"),
    FAILED("Failed"),
    IN_SYNC("InSync"),
    NO_RESPONSE("NoResponse"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RobotStatus> VALUE_MAP;
    private final String value;

    private RobotStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RobotStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RobotStatus> knownValues() {
        EnumSet<RobotStatus> knownValues = EnumSet.allOf(RobotStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RobotStatus.class, RobotStatus::toString);
    }
}

