/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentJob implements SdkPojo, Serializable, ToCopyableBuilder<DeploymentJob.Builder, DeploymentJob> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentJob::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> FLEET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentJob::fleet)).setter(setter(Builder::fleet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<DeploymentApplicationConfig>> DEPLOYMENT_APPLICATION_CONFIGS_FIELD = SdkField
            .<List<DeploymentApplicationConfig>> builder(MarshallingType.LIST)
            .getter(getter(DeploymentJob::deploymentApplicationConfigs))
            .setter(setter(Builder::deploymentApplicationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentApplicationConfigs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<DeploymentConfig> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentJob::deploymentConfig))
            .setter(setter(Builder::deploymentConfig)).constructor(DeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfig").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentJob::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentJob::failureCodeAsString)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DeploymentJob::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FLEET_FIELD,
            STATUS_FIELD, DEPLOYMENT_APPLICATION_CONFIGS_FIELD, DEPLOYMENT_CONFIG_FIELD, FAILURE_REASON_FIELD,
            FAILURE_CODE_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String fleet;

    private final String status;

    private final List<DeploymentApplicationConfig> deploymentApplicationConfigs;

    private final DeploymentConfig deploymentConfig;

    private final String failureReason;

    private final String failureCode;

    private final Instant createdAt;

    private DeploymentJob(BuilderImpl builder) {
        this.arn = builder.arn;
        this.fleet = builder.fleet;
        this.status = builder.status;
        this.deploymentApplicationConfigs = builder.deploymentApplicationConfigs;
        this.deploymentConfig = builder.deploymentConfig;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the deployment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the deployment job.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public String fleet() {
        return fleet;
    }

    /**
     * <p>
     * The status of the deployment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment job.
     * @see DeploymentStatus
     */
    public DeploymentStatus status() {
        return DeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the deployment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment job.
     * @see DeploymentStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The deployment application configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The deployment application configuration.
     */
    public List<DeploymentApplicationConfig> deploymentApplicationConfigs() {
        return deploymentApplicationConfigs;
    }

    /**
     * <p>
     * The deployment configuration.
     * </p>
     * 
     * @return The deployment configuration.
     */
    public DeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    /**
     * <p>
     * A short description of the reason why the deployment job failed.
     * </p>
     * 
     * @return A short description of the reason why the deployment job failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The deployment job failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link DeploymentJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The deployment job failure code.
     * @see DeploymentJobErrorCode
     */
    public DeploymentJobErrorCode failureCode() {
        return DeploymentJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The deployment job failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link DeploymentJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The deployment job failure code.
     * @see DeploymentJobErrorCode
     */
    public String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the deployment job was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the deployment job was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentApplicationConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentJob)) {
            return false;
        }
        DeploymentJob other = (DeploymentJob) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(fleet(), other.fleet())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(deploymentApplicationConfigs(), other.deploymentApplicationConfigs())
                && Objects.equals(deploymentConfig(), other.deploymentConfig())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentJob").add("Arn", arn()).add("Fleet", fleet()).add("Status", statusAsString())
                .add("DeploymentApplicationConfigs", deploymentApplicationConfigs()).add("DeploymentConfig", deploymentConfig())
                .add("FailureReason", failureReason()).add("FailureCode", failureCodeAsString()).add("CreatedAt", createdAt())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "fleet":
            return Optional.ofNullable(clazz.cast(fleet()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "deploymentApplicationConfigs":
            return Optional.ofNullable(clazz.cast(deploymentApplicationConfigs()));
        case "deploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentJob, T> g) {
        return obj -> g.apply((DeploymentJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentJob> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the deployment job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param fleet
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(String fleet);

        /**
         * <p>
         * The status of the deployment job.
         * </p>
         * 
         * @param status
         *        The status of the deployment job.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deployment job.
         * </p>
         * 
         * @param status
         *        The status of the deployment job.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * 
         * @param deploymentApplicationConfigs
         *        The deployment application configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * 
         * @param deploymentApplicationConfigs
         *        The deployment application configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentApplicationConfigs(DeploymentApplicationConfig... deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeploymentApplicationConfig>.Builder}
         * avoiding the need to create one manually via {@link List<DeploymentApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeploymentApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #deploymentApplicationConfigs(List<DeploymentApplicationConfig>)}.
         * 
         * @param deploymentApplicationConfigs
         *        a consumer that will call methods on {@link List<DeploymentApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentApplicationConfigs(List<DeploymentApplicationConfig>)
         */
        Builder deploymentApplicationConfigs(Consumer<DeploymentApplicationConfig.Builder>... deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment configuration.
         * </p>
         * 
         * @param deploymentConfig
         *        The deployment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(DeploymentConfig deploymentConfig);

        /**
         * <p>
         * The deployment configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentConfig.Builder} avoiding the need to
         * create one manually via {@link DeploymentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentConfig(DeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link DeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(DeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<DeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(DeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }

        /**
         * <p>
         * A short description of the reason why the deployment job failed.
         * </p>
         * 
         * @param failureReason
         *        A short description of the reason why the deployment job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The deployment job failure code.
         * </p>
         * 
         * @param failureCode
         *        The deployment job failure code.
         * @see DeploymentJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The deployment job failure code.
         * </p>
         * 
         * @param failureCode
         *        The deployment job failure code.
         * @see DeploymentJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentJobErrorCode
         */
        Builder failureCode(DeploymentJobErrorCode failureCode);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the deployment job was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the deployment job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String fleet;

        private String status;

        private List<DeploymentApplicationConfig> deploymentApplicationConfigs = DefaultSdkAutoConstructList.getInstance();

        private DeploymentConfig deploymentConfig;

        private String failureReason;

        private String failureCode;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentJob model) {
            arn(model.arn);
            fleet(model.fleet);
            status(model.status);
            deploymentApplicationConfigs(model.deploymentApplicationConfigs);
            deploymentConfig(model.deploymentConfig);
            failureReason(model.failureReason);
            failureCode(model.failureCode);
            createdAt(model.createdAt);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getFleet() {
            return fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<DeploymentApplicationConfig.Builder> getDeploymentApplicationConfigs() {
            return deploymentApplicationConfigs != null ? deploymentApplicationConfigs.stream()
                    .map(DeploymentApplicationConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copy(deploymentApplicationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(DeploymentApplicationConfig... deploymentApplicationConfigs) {
            deploymentApplicationConfigs(Arrays.asList(deploymentApplicationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(
                Consumer<DeploymentApplicationConfig.Builder>... deploymentApplicationConfigs) {
            deploymentApplicationConfigs(Stream.of(deploymentApplicationConfigs)
                    .map(c -> DeploymentApplicationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeploymentApplicationConfigs(
                Collection<DeploymentApplicationConfig.BuilderImpl> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copyFromBuilder(deploymentApplicationConfigs);
        }

        public final DeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final void setDeploymentConfig(DeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getFailureCodeAsString() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(DeploymentJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public DeploymentJob build() {
            return new DeploymentJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
