/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppVersionResourcesRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, ListAppVersionResourcesRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ListAppVersionResourcesRequest.getter(ListAppVersionResourcesRequest::appArn)).setter(ListAppVersionResourcesRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(ListAppVersionResourcesRequest.getter(ListAppVersionResourcesRequest::appVersion)).setter(ListAppVersionResourcesRequest.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAppVersionResourcesRequest.getter(ListAppVersionResourcesRequest::maxResults)).setter(ListAppVersionResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppVersionResourcesRequest.getter(ListAppVersionResourcesRequest::nextToken)).setter(ListAppVersionResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> RESOLUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolutionId").getter(ListAppVersionResourcesRequest.getter(ListAppVersionResourcesRequest::resolutionId)).setter(ListAppVersionResourcesRequest.setter(Builder::resolutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RESOLUTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAppVersionResourcesRequest.memberNameToFieldInitializer();
    private final String appArn;
    private final String appVersion;
    private final Integer maxResults;
    private final String nextToken;
    private final String resolutionId;

    private ListAppVersionResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resolutionId = builder.resolutionId;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String resolutionId() {
        return this.resolutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionResourcesRequest)) {
            return false;
        }
        ListAppVersionResourcesRequest other = (ListAppVersionResourcesRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resolutionId(), other.resolutionId());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppVersionResourcesRequest").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ResolutionId", (Object)this.resolutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resolutionId": {
                return Optional.ofNullable(clazz.cast(this.resolutionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resolutionId", RESOLUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppVersionResourcesRequest, T> g) {
        return obj -> g.apply((ListAppVersionResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private Integer maxResults;
        private String nextToken;
        private String resolutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppVersionResourcesRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.resolutionId(model.resolutionId);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResolutionId() {
            return this.resolutionId;
        }

        public final void setResolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
        }

        @Override
        public final Builder resolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAppVersionResourcesRequest build() {
            return new ListAppVersionResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppVersionResourcesRequest> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder resolutionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

