/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.MetricsExportStatusType;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMetricsExportResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, DescribeMetricsExportResponse> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(DescribeMetricsExportResponse.getter(DescribeMetricsExportResponse::errorMessage)).setter(DescribeMetricsExportResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<S3Location> EXPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exportLocation").getter(DescribeMetricsExportResponse.getter(DescribeMetricsExportResponse::exportLocation)).setter(DescribeMetricsExportResponse.setter(Builder::exportLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportLocation").build()}).build();
    private static final SdkField<String> METRICS_EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricsExportId").getter(DescribeMetricsExportResponse.getter(DescribeMetricsExportResponse::metricsExportId)).setter(DescribeMetricsExportResponse.setter(Builder::metricsExportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsExportId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeMetricsExportResponse.getter(DescribeMetricsExportResponse::statusAsString)).setter(DescribeMetricsExportResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, EXPORT_LOCATION_FIELD, METRICS_EXPORT_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMetricsExportResponse.memberNameToFieldInitializer();
    private final String errorMessage;
    private final S3Location exportLocation;
    private final String metricsExportId;
    private final String status;

    private DescribeMetricsExportResponse(BuilderImpl builder) {
        super(builder);
        this.errorMessage = builder.errorMessage;
        this.exportLocation = builder.exportLocation;
        this.metricsExportId = builder.metricsExportId;
        this.status = builder.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final S3Location exportLocation() {
        return this.exportLocation;
    }

    public final String metricsExportId() {
        return this.metricsExportId;
    }

    public final MetricsExportStatusType status() {
        return MetricsExportStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsExportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricsExportResponse)) {
            return false;
        }
        DescribeMetricsExportResponse other = (DescribeMetricsExportResponse)((Object)obj);
        return Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.exportLocation(), other.exportLocation()) && Objects.equals(this.metricsExportId(), other.metricsExportId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMetricsExportResponse").add("ErrorMessage", (Object)this.errorMessage()).add("ExportLocation", (Object)this.exportLocation()).add("MetricsExportId", (Object)this.metricsExportId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "exportLocation": {
                return Optional.ofNullable(clazz.cast(this.exportLocation()));
            }
            case "metricsExportId": {
                return Optional.ofNullable(clazz.cast(this.metricsExportId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("exportLocation", EXPORT_LOCATION_FIELD);
        map.put("metricsExportId", METRICS_EXPORT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricsExportResponse, T> g) {
        return obj -> g.apply((DescribeMetricsExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String errorMessage;
        private S3Location exportLocation;
        private String metricsExportId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricsExportResponse model) {
            super(model);
            this.errorMessage(model.errorMessage);
            this.exportLocation(model.exportLocation);
            this.metricsExportId(model.metricsExportId);
            this.status(model.status);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final S3Location.Builder getExportLocation() {
            return this.exportLocation != null ? this.exportLocation.toBuilder() : null;
        }

        public final void setExportLocation(S3Location.BuilderImpl exportLocation) {
            this.exportLocation = exportLocation != null ? exportLocation.build() : null;
        }

        @Override
        public final Builder exportLocation(S3Location exportLocation) {
            this.exportLocation = exportLocation;
            return this;
        }

        public final String getMetricsExportId() {
            return this.metricsExportId;
        }

        public final void setMetricsExportId(String metricsExportId) {
            this.metricsExportId = metricsExportId;
        }

        @Override
        public final Builder metricsExportId(String metricsExportId) {
            this.metricsExportId = metricsExportId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MetricsExportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeMetricsExportResponse build() {
            return new DescribeMetricsExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMetricsExportResponse> {
        public Builder errorMessage(String var1);

        public Builder exportLocation(S3Location var1);

        default public Builder exportLocation(Consumer<S3Location.Builder> exportLocation) {
            return this.exportLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(exportLocation)).build());
        }

        public Builder metricsExportId(String var1);

        public Builder status(String var1);

        public Builder status(MetricsExportStatusType var1);
    }
}

