/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.EksSourceClusterNamespace;
import software.amazon.awssdk.services.resiliencehub.model.ResourceMappingType;
import software.amazon.awssdk.services.resiliencehub.model.TerraformSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppInputSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppInputSource> {
    private static final SdkField<EksSourceClusterNamespace> EKS_SOURCE_CLUSTER_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksSourceClusterNamespace").getter(AppInputSource.getter(AppInputSource::eksSourceClusterNamespace)).setter(AppInputSource.setter(Builder::eksSourceClusterNamespace)).constructor(EksSourceClusterNamespace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksSourceClusterNamespace").build()}).build();
    private static final SdkField<String> IMPORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importType").getter(AppInputSource.getter(AppInputSource::importTypeAsString)).setter(AppInputSource.setter(Builder::importType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importType").build()}).build();
    private static final SdkField<Integer> RESOURCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("resourceCount").getter(AppInputSource.getter(AppInputSource::resourceCount)).setter(AppInputSource.setter(Builder::resourceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCount").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceArn").getter(AppInputSource.getter(AppInputSource::sourceArn)).setter(AppInputSource.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceName").getter(AppInputSource.getter(AppInputSource::sourceName)).setter(AppInputSource.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final SdkField<TerraformSource> TERRAFORM_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("terraformSource").getter(AppInputSource.getter(AppInputSource::terraformSource)).setter(AppInputSource.setter(Builder::terraformSource)).constructor(TerraformSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_SOURCE_CLUSTER_NAMESPACE_FIELD, IMPORT_TYPE_FIELD, RESOURCE_COUNT_FIELD, SOURCE_ARN_FIELD, SOURCE_NAME_FIELD, TERRAFORM_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppInputSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EksSourceClusterNamespace eksSourceClusterNamespace;
    private final String importType;
    private final Integer resourceCount;
    private final String sourceArn;
    private final String sourceName;
    private final TerraformSource terraformSource;

    private AppInputSource(BuilderImpl builder) {
        this.eksSourceClusterNamespace = builder.eksSourceClusterNamespace;
        this.importType = builder.importType;
        this.resourceCount = builder.resourceCount;
        this.sourceArn = builder.sourceArn;
        this.sourceName = builder.sourceName;
        this.terraformSource = builder.terraformSource;
    }

    public final EksSourceClusterNamespace eksSourceClusterNamespace() {
        return this.eksSourceClusterNamespace;
    }

    public final ResourceMappingType importType() {
        return ResourceMappingType.fromValue(this.importType);
    }

    public final String importTypeAsString() {
        return this.importType;
    }

    public final Integer resourceCount() {
        return this.resourceCount;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final TerraformSource terraformSource() {
        return this.terraformSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksSourceClusterNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.terraformSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInputSource)) {
            return false;
        }
        AppInputSource other = (AppInputSource)obj;
        return Objects.equals(this.eksSourceClusterNamespace(), other.eksSourceClusterNamespace()) && Objects.equals(this.importTypeAsString(), other.importTypeAsString()) && Objects.equals(this.resourceCount(), other.resourceCount()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.terraformSource(), other.terraformSource());
    }

    public final String toString() {
        return ToString.builder((String)"AppInputSource").add("EksSourceClusterNamespace", (Object)this.eksSourceClusterNamespace()).add("ImportType", (Object)this.importTypeAsString()).add("ResourceCount", (Object)this.resourceCount()).add("SourceArn", (Object)this.sourceArn()).add("SourceName", (Object)this.sourceName()).add("TerraformSource", (Object)this.terraformSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eksSourceClusterNamespace": {
                return Optional.ofNullable(clazz.cast(this.eksSourceClusterNamespace()));
            }
            case "importType": {
                return Optional.ofNullable(clazz.cast(this.importTypeAsString()));
            }
            case "resourceCount": {
                return Optional.ofNullable(clazz.cast(this.resourceCount()));
            }
            case "sourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "sourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "terraformSource": {
                return Optional.ofNullable(clazz.cast(this.terraformSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eksSourceClusterNamespace", EKS_SOURCE_CLUSTER_NAMESPACE_FIELD);
        map.put("importType", IMPORT_TYPE_FIELD);
        map.put("resourceCount", RESOURCE_COUNT_FIELD);
        map.put("sourceArn", SOURCE_ARN_FIELD);
        map.put("sourceName", SOURCE_NAME_FIELD);
        map.put("terraformSource", TERRAFORM_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppInputSource, T> g) {
        return obj -> g.apply((AppInputSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EksSourceClusterNamespace eksSourceClusterNamespace;
        private String importType;
        private Integer resourceCount;
        private String sourceArn;
        private String sourceName;
        private TerraformSource terraformSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInputSource model) {
            this.eksSourceClusterNamespace(model.eksSourceClusterNamespace);
            this.importType(model.importType);
            this.resourceCount(model.resourceCount);
            this.sourceArn(model.sourceArn);
            this.sourceName(model.sourceName);
            this.terraformSource(model.terraformSource);
        }

        public final EksSourceClusterNamespace.Builder getEksSourceClusterNamespace() {
            return this.eksSourceClusterNamespace != null ? this.eksSourceClusterNamespace.toBuilder() : null;
        }

        public final void setEksSourceClusterNamespace(EksSourceClusterNamespace.BuilderImpl eksSourceClusterNamespace) {
            this.eksSourceClusterNamespace = eksSourceClusterNamespace != null ? eksSourceClusterNamespace.build() : null;
        }

        @Override
        public final Builder eksSourceClusterNamespace(EksSourceClusterNamespace eksSourceClusterNamespace) {
            this.eksSourceClusterNamespace = eksSourceClusterNamespace;
            return this;
        }

        public final String getImportType() {
            return this.importType;
        }

        public final void setImportType(String importType) {
            this.importType = importType;
        }

        @Override
        public final Builder importType(String importType) {
            this.importType = importType;
            return this;
        }

        @Override
        public final Builder importType(ResourceMappingType importType) {
            this.importType(importType == null ? null : importType.toString());
            return this;
        }

        public final Integer getResourceCount() {
            return this.resourceCount;
        }

        public final void setResourceCount(Integer resourceCount) {
            this.resourceCount = resourceCount;
        }

        @Override
        public final Builder resourceCount(Integer resourceCount) {
            this.resourceCount = resourceCount;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final TerraformSource.Builder getTerraformSource() {
            return this.terraformSource != null ? this.terraformSource.toBuilder() : null;
        }

        public final void setTerraformSource(TerraformSource.BuilderImpl terraformSource) {
            this.terraformSource = terraformSource != null ? terraformSource.build() : null;
        }

        @Override
        public final Builder terraformSource(TerraformSource terraformSource) {
            this.terraformSource = terraformSource;
            return this;
        }

        public AppInputSource build() {
            return new AppInputSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppInputSource> {
        public Builder eksSourceClusterNamespace(EksSourceClusterNamespace var1);

        default public Builder eksSourceClusterNamespace(Consumer<EksSourceClusterNamespace.Builder> eksSourceClusterNamespace) {
            return this.eksSourceClusterNamespace((EksSourceClusterNamespace)((EksSourceClusterNamespace.Builder)EksSourceClusterNamespace.builder().applyMutation(eksSourceClusterNamespace)).build());
        }

        public Builder importType(String var1);

        public Builder importType(ResourceMappingType var1);

        public Builder resourceCount(Integer var1);

        public Builder sourceArn(String var1);

        public Builder sourceName(String var1);

        public Builder terraformSource(TerraformSource var1);

        default public Builder terraformSource(Consumer<TerraformSource.Builder> terraformSource) {
            return this.terraformSource((TerraformSource)((TerraformSource.Builder)TerraformSource.builder().applyMutation(terraformSource)).build());
        }
    }
}

