/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishAppVersionResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, PublishAppVersionResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(PublishAppVersionResponse.getter(PublishAppVersionResponse::appArn)).setter(PublishAppVersionResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(PublishAppVersionResponse.getter(PublishAppVersionResponse::appVersion)).setter(PublishAppVersionResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<Long> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("identifier").getter(PublishAppVersionResponse.getter(PublishAppVersionResponse::identifier)).setter(PublishAppVersionResponse.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(PublishAppVersionResponse.getter(PublishAppVersionResponse::versionName)).setter(PublishAppVersionResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, IDENTIFIER_FIELD, VERSION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("appVersion", APP_VERSION_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("versionName", VERSION_NAME_FIELD);
        }
    });
    private final String appArn;
    private final String appVersion;
    private final Long identifier;
    private final String versionName;

    private PublishAppVersionResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.identifier = builder.identifier;
        this.versionName = builder.versionName;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final Long identifier() {
        return this.identifier;
    }

    public final String versionName() {
        return this.versionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishAppVersionResponse)) {
            return false;
        }
        PublishAppVersionResponse other = (PublishAppVersionResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.versionName(), other.versionName());
    }

    public final String toString() {
        return ToString.builder((String)"PublishAppVersionResponse").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("Identifier", (Object)this.identifier()).add("VersionName", (Object)this.versionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublishAppVersionResponse, T> g) {
        return obj -> g.apply((PublishAppVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private Long identifier;
        private String versionName;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishAppVersionResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.identifier(model.identifier);
            this.versionName(model.versionName);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Long getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(Long identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(Long identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        @Override
        public PublishAppVersionResponse build() {
            return new PublishAppVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishAppVersionResponse> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder identifier(Long var1);

        public Builder versionName(String var1);
    }
}

