/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplate;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplateListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendationTemplatesResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListRecommendationTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecommendationTemplatesResponse.getter(ListRecommendationTemplatesResponse::nextToken)).setter(ListRecommendationTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RecommendationTemplate>> RECOMMENDATION_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationTemplates").getter(ListRecommendationTemplatesResponse.getter(ListRecommendationTemplatesResponse::recommendationTemplates)).setter(ListRecommendationTemplatesResponse.setter(Builder::recommendationTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECOMMENDATION_TEMPLATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("recommendationTemplates", RECOMMENDATION_TEMPLATES_FIELD);
        }
    });
    private final String nextToken;
    private final List<RecommendationTemplate> recommendationTemplates;

    private ListRecommendationTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recommendationTemplates = builder.recommendationTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecommendationTemplates() {
        return this.recommendationTemplates != null && !(this.recommendationTemplates instanceof SdkAutoConstructList);
    }

    public final List<RecommendationTemplate> recommendationTemplates() {
        return this.recommendationTemplates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationTemplates() ? this.recommendationTemplates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationTemplatesResponse)) {
            return false;
        }
        ListRecommendationTemplatesResponse other = (ListRecommendationTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecommendationTemplates() == other.hasRecommendationTemplates() && Objects.equals(this.recommendationTemplates(), other.recommendationTemplates());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendationTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("RecommendationTemplates", this.hasRecommendationTemplates() ? this.recommendationTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "recommendationTemplates": {
                return Optional.ofNullable(clazz.cast(this.recommendationTemplates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationTemplatesResponse, T> g) {
        return obj -> g.apply((ListRecommendationTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecommendationTemplate> recommendationTemplates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.recommendationTemplates(model.recommendationTemplates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecommendationTemplate.Builder> getRecommendationTemplates() {
            List<RecommendationTemplate.Builder> result = RecommendationTemplateListCopier.copyToBuilder(this.recommendationTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationTemplates(Collection<RecommendationTemplate.BuilderImpl> recommendationTemplates) {
            this.recommendationTemplates = RecommendationTemplateListCopier.copyFromBuilder(recommendationTemplates);
        }

        @Override
        public final Builder recommendationTemplates(Collection<RecommendationTemplate> recommendationTemplates) {
            this.recommendationTemplates = RecommendationTemplateListCopier.copy(recommendationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationTemplates(RecommendationTemplate ... recommendationTemplates) {
            this.recommendationTemplates(Arrays.asList(recommendationTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationTemplates(Consumer<RecommendationTemplate.Builder> ... recommendationTemplates) {
            this.recommendationTemplates(Stream.of(recommendationTemplates).map(c -> (RecommendationTemplate)((RecommendationTemplate.Builder)RecommendationTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRecommendationTemplatesResponse build() {
            return new ListRecommendationTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendationTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder recommendationTemplates(Collection<RecommendationTemplate> var1);

        public Builder recommendationTemplates(RecommendationTemplate ... var1);

        public Builder recommendationTemplates(Consumer<RecommendationTemplate.Builder> ... var1);
    }
}

