/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusFailedEntriesCopier;
import software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusFailedEntry;
import software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusSuccessfulEntriesCopier;
import software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusSuccessfulEntry;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateRecommendationStatusResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, BatchUpdateRecommendationStatusResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(BatchUpdateRecommendationStatusResponse.getter(BatchUpdateRecommendationStatusResponse::appArn)).setter(BatchUpdateRecommendationStatusResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<List<BatchUpdateRecommendationStatusFailedEntry>> FAILED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedEntries").getter(BatchUpdateRecommendationStatusResponse.getter(BatchUpdateRecommendationStatusResponse::failedEntries)).setter(BatchUpdateRecommendationStatusResponse.setter(Builder::failedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateRecommendationStatusFailedEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUpdateRecommendationStatusSuccessfulEntry>> SUCCESSFUL_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successfulEntries").getter(BatchUpdateRecommendationStatusResponse.getter(BatchUpdateRecommendationStatusResponse::successfulEntries)).setter(BatchUpdateRecommendationStatusResponse.setter(Builder::successfulEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateRecommendationStatusSuccessfulEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, FAILED_ENTRIES_FIELD, SUCCESSFUL_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("failedEntries", FAILED_ENTRIES_FIELD);
            this.put("successfulEntries", SUCCESSFUL_ENTRIES_FIELD);
        }
    });
    private final String appArn;
    private final List<BatchUpdateRecommendationStatusFailedEntry> failedEntries;
    private final List<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries;

    private BatchUpdateRecommendationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.failedEntries = builder.failedEntries;
        this.successfulEntries = builder.successfulEntries;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final boolean hasFailedEntries() {
        return this.failedEntries != null && !(this.failedEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateRecommendationStatusFailedEntry> failedEntries() {
        return this.failedEntries;
    }

    public final boolean hasSuccessfulEntries() {
        return this.successfulEntries != null && !(this.successfulEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries() {
        return this.successfulEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedEntries() ? this.failedEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulEntries() ? this.successfulEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRecommendationStatusResponse)) {
            return false;
        }
        BatchUpdateRecommendationStatusResponse other = (BatchUpdateRecommendationStatusResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && this.hasFailedEntries() == other.hasFailedEntries() && Objects.equals(this.failedEntries(), other.failedEntries()) && this.hasSuccessfulEntries() == other.hasSuccessfulEntries() && Objects.equals(this.successfulEntries(), other.successfulEntries());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateRecommendationStatusResponse").add("AppArn", (Object)this.appArn()).add("FailedEntries", this.hasFailedEntries() ? this.failedEntries() : null).add("SuccessfulEntries", this.hasSuccessfulEntries() ? this.successfulEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "failedEntries": {
                return Optional.ofNullable(clazz.cast(this.failedEntries()));
            }
            case "successfulEntries": {
                return Optional.ofNullable(clazz.cast(this.successfulEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRecommendationStatusResponse, T> g) {
        return obj -> g.apply((BatchUpdateRecommendationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private List<BatchUpdateRecommendationStatusFailedEntry> failedEntries = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRecommendationStatusResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.failedEntries(model.failedEntries);
            this.successfulEntries(model.successfulEntries);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<BatchUpdateRecommendationStatusFailedEntry.Builder> getFailedEntries() {
            List<BatchUpdateRecommendationStatusFailedEntry.Builder> result = BatchUpdateRecommendationStatusFailedEntriesCopier.copyToBuilder(this.failedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedEntries(Collection<BatchUpdateRecommendationStatusFailedEntry.BuilderImpl> failedEntries) {
            this.failedEntries = BatchUpdateRecommendationStatusFailedEntriesCopier.copyFromBuilder(failedEntries);
        }

        @Override
        public final Builder failedEntries(Collection<BatchUpdateRecommendationStatusFailedEntry> failedEntries) {
            this.failedEntries = BatchUpdateRecommendationStatusFailedEntriesCopier.copy(failedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(BatchUpdateRecommendationStatusFailedEntry ... failedEntries) {
            this.failedEntries(Arrays.asList(failedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(Consumer<BatchUpdateRecommendationStatusFailedEntry.Builder> ... failedEntries) {
            this.failedEntries(Stream.of(failedEntries).map(c -> (BatchUpdateRecommendationStatusFailedEntry)((BatchUpdateRecommendationStatusFailedEntry.Builder)BatchUpdateRecommendationStatusFailedEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateRecommendationStatusSuccessfulEntry.Builder> getSuccessfulEntries() {
            List<BatchUpdateRecommendationStatusSuccessfulEntry.Builder> result = BatchUpdateRecommendationStatusSuccessfulEntriesCopier.copyToBuilder(this.successfulEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulEntries(Collection<BatchUpdateRecommendationStatusSuccessfulEntry.BuilderImpl> successfulEntries) {
            this.successfulEntries = BatchUpdateRecommendationStatusSuccessfulEntriesCopier.copyFromBuilder(successfulEntries);
        }

        @Override
        public final Builder successfulEntries(Collection<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries) {
            this.successfulEntries = BatchUpdateRecommendationStatusSuccessfulEntriesCopier.copy(successfulEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulEntries(BatchUpdateRecommendationStatusSuccessfulEntry ... successfulEntries) {
            this.successfulEntries(Arrays.asList(successfulEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulEntries(Consumer<BatchUpdateRecommendationStatusSuccessfulEntry.Builder> ... successfulEntries) {
            this.successfulEntries(Stream.of(successfulEntries).map(c -> (BatchUpdateRecommendationStatusSuccessfulEntry)((BatchUpdateRecommendationStatusSuccessfulEntry.Builder)BatchUpdateRecommendationStatusSuccessfulEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateRecommendationStatusResponse build() {
            return new BatchUpdateRecommendationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateRecommendationStatusResponse> {
        public Builder appArn(String var1);

        public Builder failedEntries(Collection<BatchUpdateRecommendationStatusFailedEntry> var1);

        public Builder failedEntries(BatchUpdateRecommendationStatusFailedEntry ... var1);

        public Builder failedEntries(Consumer<BatchUpdateRecommendationStatusFailedEntry.Builder> ... var1);

        public Builder successfulEntries(Collection<BatchUpdateRecommendationStatusSuccessfulEntry> var1);

        public Builder successfulEntries(BatchUpdateRecommendationStatusSuccessfulEntry ... var1);

        public Builder successfulEntries(Consumer<BatchUpdateRecommendationStatusSuccessfulEntry.Builder> ... var1);
    }
}

