/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.AppAssessmentScheduleType;
import software.amazon.awssdk.services.resiliencehub.model.AppComplianceStatusType;
import software.amazon.awssdk.services.resiliencehub.model.AppDriftStatusType;
import software.amazon.awssdk.services.resiliencehub.model.AppStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppSummary> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(AppSummary.getter(AppSummary::appArn)).setter(AppSummary.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentSchedule").getter(AppSummary.getter(AppSummary::assessmentScheduleAsString)).setter(AppSummary.setter(Builder::assessmentSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSchedule").build()}).build();
    private static final SdkField<String> AWS_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsApplicationArn").getter(AppSummary.getter(AppSummary::awsApplicationArn)).setter(AppSummary.setter(Builder::awsApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsApplicationArn").build()}).build();
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceStatus").getter(AppSummary.getter(AppSummary::complianceStatusAsString)).setter(AppSummary.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AppSummary.getter(AppSummary::creationTime)).setter(AppSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AppSummary.getter(AppSummary::description)).setter(AppSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("driftStatus").getter(AppSummary.getter(AppSummary::driftStatusAsString)).setter(AppSummary.setter(Builder::driftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()}).build();
    private static final SdkField<Instant> LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAppComplianceEvaluationTime").getter(AppSummary.getter(AppSummary::lastAppComplianceEvaluationTime)).setter(AppSummary.setter(Builder::lastAppComplianceEvaluationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAppComplianceEvaluationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AppSummary.getter(AppSummary::name)).setter(AppSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Double> RESILIENCY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("resiliencyScore").getter(AppSummary.getter(AppSummary::resiliencyScore)).setter(AppSummary.setter(Builder::resiliencyScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()}).build();
    private static final SdkField<Integer> RPO_IN_SECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rpoInSecs").getter(AppSummary.getter(AppSummary::rpoInSecs)).setter(AppSummary.setter(Builder::rpoInSecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rpoInSecs").build()}).build();
    private static final SdkField<Integer> RTO_IN_SECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rtoInSecs").getter(AppSummary.getter(AppSummary::rtoInSecs)).setter(AppSummary.setter(Builder::rtoInSecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtoInSecs").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AppSummary.getter(AppSummary::statusAsString)).setter(AppSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, ASSESSMENT_SCHEDULE_FIELD, AWS_APPLICATION_ARN_FIELD, COMPLIANCE_STATUS_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, DRIFT_STATUS_FIELD, LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD, NAME_FIELD, RESILIENCY_SCORE_FIELD, RPO_IN_SECS_FIELD, RTO_IN_SECS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appArn;
    private final String assessmentSchedule;
    private final String awsApplicationArn;
    private final String complianceStatus;
    private final Instant creationTime;
    private final String description;
    private final String driftStatus;
    private final Instant lastAppComplianceEvaluationTime;
    private final String name;
    private final Double resiliencyScore;
    private final Integer rpoInSecs;
    private final Integer rtoInSecs;
    private final String status;

    private AppSummary(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.assessmentSchedule = builder.assessmentSchedule;
        this.awsApplicationArn = builder.awsApplicationArn;
        this.complianceStatus = builder.complianceStatus;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.driftStatus = builder.driftStatus;
        this.lastAppComplianceEvaluationTime = builder.lastAppComplianceEvaluationTime;
        this.name = builder.name;
        this.resiliencyScore = builder.resiliencyScore;
        this.rpoInSecs = builder.rpoInSecs;
        this.rtoInSecs = builder.rtoInSecs;
        this.status = builder.status;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final AppAssessmentScheduleType assessmentSchedule() {
        return AppAssessmentScheduleType.fromValue(this.assessmentSchedule);
    }

    public final String assessmentScheduleAsString() {
        return this.assessmentSchedule;
    }

    public final String awsApplicationArn() {
        return this.awsApplicationArn;
    }

    public final AppComplianceStatusType complianceStatus() {
        return AppComplianceStatusType.fromValue(this.complianceStatus);
    }

    public final String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final AppDriftStatusType driftStatus() {
        return AppDriftStatusType.fromValue(this.driftStatus);
    }

    public final String driftStatusAsString() {
        return this.driftStatus;
    }

    public final Instant lastAppComplianceEvaluationTime() {
        return this.lastAppComplianceEvaluationTime;
    }

    public final String name() {
        return this.name;
    }

    public final Double resiliencyScore() {
        return this.resiliencyScore;
    }

    public final Integer rpoInSecs() {
        return this.rpoInSecs;
    }

    public final Integer rtoInSecs() {
        return this.rtoInSecs;
    }

    public final AppStatusType status() {
        return AppStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAppComplianceEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.rpoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(this.rtoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSummary)) {
            return false;
        }
        AppSummary other = (AppSummary)obj;
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.assessmentScheduleAsString(), other.assessmentScheduleAsString()) && Objects.equals(this.awsApplicationArn(), other.awsApplicationArn()) && Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.driftStatusAsString(), other.driftStatusAsString()) && Objects.equals(this.lastAppComplianceEvaluationTime(), other.lastAppComplianceEvaluationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resiliencyScore(), other.resiliencyScore()) && Objects.equals(this.rpoInSecs(), other.rpoInSecs()) && Objects.equals(this.rtoInSecs(), other.rtoInSecs()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AppSummary").add("AppArn", (Object)this.appArn()).add("AssessmentSchedule", (Object)this.assessmentScheduleAsString()).add("AwsApplicationArn", (Object)this.awsApplicationArn()).add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("DriftStatus", (Object)this.driftStatusAsString()).add("LastAppComplianceEvaluationTime", (Object)this.lastAppComplianceEvaluationTime()).add("Name", (Object)this.name()).add("ResiliencyScore", (Object)this.resiliencyScore()).add("RpoInSecs", (Object)this.rpoInSecs()).add("RtoInSecs", (Object)this.rtoInSecs()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "assessmentSchedule": {
                return Optional.ofNullable(clazz.cast(this.assessmentScheduleAsString()));
            }
            case "awsApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.awsApplicationArn()));
            }
            case "complianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "driftStatus": {
                return Optional.ofNullable(clazz.cast(this.driftStatusAsString()));
            }
            case "lastAppComplianceEvaluationTime": {
                return Optional.ofNullable(clazz.cast(this.lastAppComplianceEvaluationTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resiliencyScore": {
                return Optional.ofNullable(clazz.cast(this.resiliencyScore()));
            }
            case "rpoInSecs": {
                return Optional.ofNullable(clazz.cast(this.rpoInSecs()));
            }
            case "rtoInSecs": {
                return Optional.ofNullable(clazz.cast(this.rtoInSecs()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppSummary, T> g) {
        return obj -> g.apply((AppSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appArn;
        private String assessmentSchedule;
        private String awsApplicationArn;
        private String complianceStatus;
        private Instant creationTime;
        private String description;
        private String driftStatus;
        private Instant lastAppComplianceEvaluationTime;
        private String name;
        private Double resiliencyScore;
        private Integer rpoInSecs;
        private Integer rtoInSecs;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSummary model) {
            this.appArn(model.appArn);
            this.assessmentSchedule(model.assessmentSchedule);
            this.awsApplicationArn(model.awsApplicationArn);
            this.complianceStatus(model.complianceStatus);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.driftStatus(model.driftStatus);
            this.lastAppComplianceEvaluationTime(model.lastAppComplianceEvaluationTime);
            this.name(model.name);
            this.resiliencyScore(model.resiliencyScore);
            this.rpoInSecs(model.rpoInSecs);
            this.rtoInSecs(model.rtoInSecs);
            this.status(model.status);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAssessmentSchedule() {
            return this.assessmentSchedule;
        }

        public final void setAssessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
        }

        @Override
        public final Builder assessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
            return this;
        }

        @Override
        public final Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
            this.assessmentSchedule(assessmentSchedule == null ? null : assessmentSchedule.toString());
            return this;
        }

        public final String getAwsApplicationArn() {
            return this.awsApplicationArn;
        }

        public final void setAwsApplicationArn(String awsApplicationArn) {
            this.awsApplicationArn = awsApplicationArn;
        }

        @Override
        public final Builder awsApplicationArn(String awsApplicationArn) {
            this.awsApplicationArn = awsApplicationArn;
            return this;
        }

        public final String getComplianceStatus() {
            return this.complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(AppComplianceStatusType complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDriftStatus() {
            return this.driftStatus;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(AppDriftStatusType driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final Instant getLastAppComplianceEvaluationTime() {
            return this.lastAppComplianceEvaluationTime;
        }

        public final void setLastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime) {
            this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
        }

        @Override
        public final Builder lastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime) {
            this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Double getResiliencyScore() {
            return this.resiliencyScore;
        }

        public final void setResiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
        }

        @Override
        public final Builder resiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final Integer getRpoInSecs() {
            return this.rpoInSecs;
        }

        public final void setRpoInSecs(Integer rpoInSecs) {
            this.rpoInSecs = rpoInSecs;
        }

        @Override
        public final Builder rpoInSecs(Integer rpoInSecs) {
            this.rpoInSecs = rpoInSecs;
            return this;
        }

        public final Integer getRtoInSecs() {
            return this.rtoInSecs;
        }

        public final void setRtoInSecs(Integer rtoInSecs) {
            this.rtoInSecs = rtoInSecs;
        }

        @Override
        public final Builder rtoInSecs(Integer rtoInSecs) {
            this.rtoInSecs = rtoInSecs;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public AppSummary build() {
            return new AppSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppSummary> {
        public Builder appArn(String var1);

        public Builder assessmentSchedule(String var1);

        public Builder assessmentSchedule(AppAssessmentScheduleType var1);

        public Builder awsApplicationArn(String var1);

        public Builder complianceStatus(String var1);

        public Builder complianceStatus(AppComplianceStatusType var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder driftStatus(String var1);

        public Builder driftStatus(AppDriftStatusType var1);

        public Builder lastAppComplianceEvaluationTime(Instant var1);

        public Builder name(String var1);

        public Builder resiliencyScore(Double var1);

        public Builder rpoInSecs(Integer var1);

        public Builder rtoInSecs(Integer var1);

        public Builder status(String var1);

        public Builder status(AppStatusType var1);
    }
}

