/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppComponent;

final class AppComponentListCopier {
    AppComponentListCopier() {
    }

    static List<AppComponent> copy(Collection<? extends AppComponent> appComponentListParam) {
        Object list;
        if (appComponentListParam == null || appComponentListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            appComponentListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AppComponent> copyFromBuilder(Collection<? extends AppComponent.Builder> appComponentListParam) {
        Object list;
        if (appComponentListParam == null || appComponentListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            appComponentListParam.forEach(entry -> {
                AppComponent member = entry == null ? null : (AppComponent)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AppComponent.Builder> copyToBuilder(Collection<? extends AppComponent> appComponentListParam) {
        Object list;
        if (appComponentListParam == null || appComponentListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            appComponentListParam.forEach(entry -> {
                AppComponent.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

