/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates an event you would like to subscribe and get notification for. Currently, Resilience Hub supports
 * notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<EventSubscription.Builder, EventSubscription> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(EventSubscription::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EventSubscription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snsTopicArn").getter(getter(EventSubscription::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, NAME_FIELD,
            SNS_TOPIC_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final String name;

    private final String snsTopicArn;

    private EventSubscription(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.name = builder.name;
        this.snsTopicArn = builder.snsTopicArn;
    }

    /**
     * <p>
     * The type of event you would like to subscribe and get notification for. Currently, Resilience Hub supports
     * notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled assessment failure</b>
     * (<code>ScheduledAssessmentFailure</code>) events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event you would like to subscribe and get notification for. Currently, Resilience Hub
     *         supports notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled
     *         assessment failure</b> (<code>ScheduledAssessmentFailure</code>) events.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of event you would like to subscribe and get notification for. Currently, Resilience Hub supports
     * notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled assessment failure</b>
     * (<code>ScheduledAssessmentFailure</code>) events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event you would like to subscribe and get notification for. Currently, Resilience Hub
     *         supports notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled
     *         assessment failure</b> (<code>ScheduledAssessmentFailure</code>) events.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * Unique name to identify an event subscription.
     * </p>
     * 
     * @return Unique name to identify an event subscription.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic. The format for this ARN is:
     * <code>arn:partition:sns:region:account:topic-name</code>. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic. The format for this ARN is:
     *         <code>arn:partition:sns:region:account:topic-name</code>. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription) obj;
        return Objects.equals(eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(snsTopicArn(), other.snsTopicArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventSubscription").add("EventType", eventTypeAsString()).add("Name", name())
                .add("SnsTopicArn", snsTopicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "snsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSubscription, T> g) {
        return obj -> g.apply((EventSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSubscription> {
        /**
         * <p>
         * The type of event you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled assessment
         * failure</b> (<code>ScheduledAssessmentFailure</code>) events.
         * </p>
         * 
         * @param eventType
         *        The type of event you would like to subscribe and get notification for. Currently, Resilience Hub
         *        supports notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled
         *        assessment failure</b> (<code>ScheduledAssessmentFailure</code>) events.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of event you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled assessment
         * failure</b> (<code>ScheduledAssessmentFailure</code>) events.
         * </p>
         * 
         * @param eventType
         *        The type of event you would like to subscribe and get notification for. Currently, Resilience Hub
         *        supports notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled
         *        assessment failure</b> (<code>ScheduledAssessmentFailure</code>) events.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * Unique name to identify an event subscription.
         * </p>
         * 
         * @param name
         *        Unique name to identify an event subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic. The format for this ARN is:
         * <code>arn:partition:sns:region:account:topic-name</code>. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param snsTopicArn
         *        Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic. The format for this ARN
         *        is: <code>arn:partition:sns:region:account:topic-name</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private String name;

        private String snsTopicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSubscription model) {
            eventType(model.eventType);
            name(model.name);
            snsTopicArn(model.snsTopicArn);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        @Override
        public EventSubscription build() {
            return new EventSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
