/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppAssessmentRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<DescribeAppAssessmentRequest.Builder, DescribeAppAssessmentRequest> {
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentArn").getter(getter(DescribeAppAssessmentRequest::assessmentArn))
            .setter(setter(Builder::assessmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ARN_FIELD));

    private final String assessmentArn;

    private DescribeAppAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentArn = builder.assessmentArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information
     * about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
     * Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
     *         information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String assessmentArn() {
        return assessmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppAssessmentRequest)) {
            return false;
        }
        DescribeAppAssessmentRequest other = (DescribeAppAssessmentRequest) obj;
        return Objects.equals(assessmentArn(), other.assessmentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppAssessmentRequest").add("AssessmentArn", assessmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentArn":
            return Optional.ofNullable(clazz.cast(assessmentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppAssessmentRequest, T> g) {
        return obj -> g.apply((DescribeAppAssessmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAppAssessmentRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param assessmentArn
         *        Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
         *        :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
         *        information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentArn(String assessmentArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String assessmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppAssessmentRequest model) {
            super(model);
            assessmentArn(model.assessmentArn);
        }

        public final String getAssessmentArn() {
            return assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAppAssessmentRequest build() {
            return new DescribeAppAssessmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
