/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) that were detected
 * for an assessed entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceDrift implements SdkPojo, Serializable, ToCopyableBuilder<ComplianceDrift.Builder, ComplianceDrift> {
    private static final SdkField<String> ACTUAL_REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actualReferenceId").getter(getter(ComplianceDrift::actualReferenceId))
            .setter(setter(Builder::actualReferenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualReferenceId").build()).build();

    private static final SdkField<Map<String, DisruptionCompliance>> ACTUAL_VALUE_FIELD = SdkField
            .<Map<String, DisruptionCompliance>> builder(MarshallingType.MAP)
            .memberName("actualValue")
            .getter(getter(ComplianceDrift::actualValueAsStrings))
            .setter(setter(Builder::actualValueWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualValue").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DisruptionCompliance> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisruptionCompliance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(ComplianceDrift::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(ComplianceDrift::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<String> DIFF_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diffType").getter(getter(ComplianceDrift::diffTypeAsString)).setter(setter(Builder::diffType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diffType").build()).build();

    private static final SdkField<String> DRIFT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("driftType").getter(getter(ComplianceDrift::driftTypeAsString)).setter(setter(Builder::driftType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftType").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(ComplianceDrift::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(ComplianceDrift::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final SdkField<String> EXPECTED_REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedReferenceId").getter(getter(ComplianceDrift::expectedReferenceId))
            .setter(setter(Builder::expectedReferenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedReferenceId").build())
            .build();

    private static final SdkField<Map<String, DisruptionCompliance>> EXPECTED_VALUE_FIELD = SdkField
            .<Map<String, DisruptionCompliance>> builder(MarshallingType.MAP)
            .memberName("expectedValue")
            .getter(getter(ComplianceDrift::expectedValueAsStrings))
            .setter(setter(Builder::expectedValueWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedValue").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DisruptionCompliance> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisruptionCompliance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_REFERENCE_ID_FIELD,
            ACTUAL_VALUE_FIELD, APP_ID_FIELD, APP_VERSION_FIELD, DIFF_TYPE_FIELD, DRIFT_TYPE_FIELD, ENTITY_ID_FIELD,
            ENTITY_TYPE_FIELD, EXPECTED_REFERENCE_ID_FIELD, EXPECTED_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actualReferenceId;

    private final Map<String, DisruptionCompliance> actualValue;

    private final String appId;

    private final String appVersion;

    private final String diffType;

    private final String driftType;

    private final String entityId;

    private final String entityType;

    private final String expectedReferenceId;

    private final Map<String, DisruptionCompliance> expectedValue;

    private ComplianceDrift(BuilderImpl builder) {
        this.actualReferenceId = builder.actualReferenceId;
        this.actualValue = builder.actualValue;
        this.appId = builder.appId;
        this.appVersion = builder.appVersion;
        this.diffType = builder.diffType;
        this.driftType = builder.driftType;
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.expectedReferenceId = builder.expectedReferenceId;
        this.expectedValue = builder.expectedValue;
    }

    /**
     * <p>
     * Assessment identifier that is associated with this drift item.
     * </p>
     * 
     * @return Assessment identifier that is associated with this drift item.
     */
    public final String actualReferenceId() {
        return actualReferenceId;
    }

    /**
     * <p>
     * Actual compliance value of the entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActualValue} method.
     * </p>
     * 
     * @return Actual compliance value of the entity.
     */
    public final Map<DisruptionType, DisruptionCompliance> actualValue() {
        return AssessmentComplianceCopier.copyStringToEnum(actualValue);
    }

    /**
     * For responses, this returns true if the service returned a value for the ActualValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActualValue() {
        return actualValue != null && !(actualValue instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Actual compliance value of the entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActualValue} method.
     * </p>
     * 
     * @return Actual compliance value of the entity.
     */
    public final Map<String, DisruptionCompliance> actualValueAsStrings() {
        return actualValue;
    }

    /**
     * <p>
     * Identifier of your application.
     * </p>
     * 
     * @return Identifier of your application.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * Published version of your application on which drift was detected.
     * </p>
     * 
     * @return Published version of your application on which drift was detected.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * Difference type between actual and expected recovery point objective (RPO) and recovery time objective (RTO)
     * values. Currently, Resilience Hub supports only <b>NotEqual</b> difference type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diffType} will
     * return {@link DifferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #diffTypeAsString}.
     * </p>
     * 
     * @return Difference type between actual and expected recovery point objective (RPO) and recovery time objective
     *         (RTO) values. Currently, Resilience Hub supports only <b>NotEqual</b> difference type.
     * @see DifferenceType
     */
    public final DifferenceType diffType() {
        return DifferenceType.fromValue(diffType);
    }

    /**
     * <p>
     * Difference type between actual and expected recovery point objective (RPO) and recovery time objective (RTO)
     * values. Currently, Resilience Hub supports only <b>NotEqual</b> difference type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diffType} will
     * return {@link DifferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #diffTypeAsString}.
     * </p>
     * 
     * @return Difference type between actual and expected recovery point objective (RPO) and recovery time objective
     *         (RTO) values. Currently, Resilience Hub supports only <b>NotEqual</b> difference type.
     * @see DifferenceType
     */
    public final String diffTypeAsString() {
        return diffType;
    }

    /**
     * <p>
     * The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftType} will
     * return {@link DriftType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftTypeAsString}.
     * </p>
     * 
     * @return The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift
     *         type.
     * @see DriftType
     */
    public final DriftType driftType() {
        return DriftType.fromValue(driftType);
    }

    /**
     * <p>
     * The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftType} will
     * return {@link DriftType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftTypeAsString}.
     * </p>
     * 
     * @return The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift
     *         type.
     * @see DriftType
     */
    public final String driftTypeAsString() {
        return driftType;
    }

    /**
     * <p>
     * Identifier of an entity in which drift was detected. For compliance drift, the entity ID can be either
     * application ID or the AppComponent ID.
     * </p>
     * 
     * @return Identifier of an entity in which drift was detected. For compliance drift, the entity ID can be either
     *         application ID or the AppComponent ID.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The type of entity in which drift was detected. For compliance drifts, Resilience Hub supports
     * <code>AWS::ResilienceHub::AppComponent</code> and <code>AWS::ResilienceHub::Application</code>.
     * </p>
     * 
     * @return The type of entity in which drift was detected. For compliance drifts, Resilience Hub supports
     *         <code>AWS::ResilienceHub::AppComponent</code> and <code>AWS::ResilienceHub::Application</code>.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * <p>
     * Assessment identifier of a previous assessment of the same application version. Resilience Hub uses the previous
     * assessment (associated with the reference identifier) to compare the compliance with the current assessment to
     * identify drifts.
     * </p>
     * 
     * @return Assessment identifier of a previous assessment of the same application version. Resilience Hub uses the
     *         previous assessment (associated with the reference identifier) to compare the compliance with the current
     *         assessment to identify drifts.
     */
    public final String expectedReferenceId() {
        return expectedReferenceId;
    }

    /**
     * <p>
     * The expected compliance value of an entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedValue} method.
     * </p>
     * 
     * @return The expected compliance value of an entity.
     */
    public final Map<DisruptionType, DisruptionCompliance> expectedValue() {
        return AssessmentComplianceCopier.copyStringToEnum(expectedValue);
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExpectedValue() {
        return expectedValue != null && !(expectedValue instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The expected compliance value of an entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedValue} method.
     * </p>
     * 
     * @return The expected compliance value of an entity.
     */
    public final Map<String, DisruptionCompliance> expectedValueAsStrings() {
        return expectedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actualReferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasActualValue() ? actualValueAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(diffTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(driftTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(expectedReferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedValue() ? expectedValueAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceDrift)) {
            return false;
        }
        ComplianceDrift other = (ComplianceDrift) obj;
        return Objects.equals(actualReferenceId(), other.actualReferenceId()) && hasActualValue() == other.hasActualValue()
                && Objects.equals(actualValueAsStrings(), other.actualValueAsStrings()) && Objects.equals(appId(), other.appId())
                && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(diffTypeAsString(), other.diffTypeAsString())
                && Objects.equals(driftTypeAsString(), other.driftTypeAsString()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(entityType(), other.entityType())
                && Objects.equals(expectedReferenceId(), other.expectedReferenceId())
                && hasExpectedValue() == other.hasExpectedValue()
                && Objects.equals(expectedValueAsStrings(), other.expectedValueAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComplianceDrift").add("ActualReferenceId", actualReferenceId())
                .add("ActualValue", hasActualValue() ? actualValueAsStrings() : null).add("AppId", appId())
                .add("AppVersion", appVersion()).add("DiffType", diffTypeAsString()).add("DriftType", driftTypeAsString())
                .add("EntityId", entityId()).add("EntityType", entityType()).add("ExpectedReferenceId", expectedReferenceId())
                .add("ExpectedValue", hasExpectedValue() ? expectedValueAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actualReferenceId":
            return Optional.ofNullable(clazz.cast(actualReferenceId()));
        case "actualValue":
            return Optional.ofNullable(clazz.cast(actualValueAsStrings()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "diffType":
            return Optional.ofNullable(clazz.cast(diffTypeAsString()));
        case "driftType":
            return Optional.ofNullable(clazz.cast(driftTypeAsString()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "expectedReferenceId":
            return Optional.ofNullable(clazz.cast(expectedReferenceId()));
        case "expectedValue":
            return Optional.ofNullable(clazz.cast(expectedValueAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceDrift, T> g) {
        return obj -> g.apply((ComplianceDrift) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComplianceDrift> {
        /**
         * <p>
         * Assessment identifier that is associated with this drift item.
         * </p>
         * 
         * @param actualReferenceId
         *        Assessment identifier that is associated with this drift item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualReferenceId(String actualReferenceId);

        /**
         * <p>
         * Actual compliance value of the entity.
         * </p>
         * 
         * @param actualValue
         *        Actual compliance value of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualValueWithStrings(Map<String, DisruptionCompliance> actualValue);

        /**
         * <p>
         * Actual compliance value of the entity.
         * </p>
         * 
         * @param actualValue
         *        Actual compliance value of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualValue(Map<DisruptionType, DisruptionCompliance> actualValue);

        /**
         * <p>
         * Identifier of your application.
         * </p>
         * 
         * @param appId
         *        Identifier of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Published version of your application on which drift was detected.
         * </p>
         * 
         * @param appVersion
         *        Published version of your application on which drift was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * Difference type between actual and expected recovery point objective (RPO) and recovery time objective (RTO)
         * values. Currently, Resilience Hub supports only <b>NotEqual</b> difference type.
         * </p>
         * 
         * @param diffType
         *        Difference type between actual and expected recovery point objective (RPO) and recovery time objective
         *        (RTO) values. Currently, Resilience Hub supports only <b>NotEqual</b> difference type.
         * @see DifferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceType
         */
        Builder diffType(String diffType);

        /**
         * <p>
         * Difference type between actual and expected recovery point objective (RPO) and recovery time objective (RTO)
         * values. Currently, Resilience Hub supports only <b>NotEqual</b> difference type.
         * </p>
         * 
         * @param diffType
         *        Difference type between actual and expected recovery point objective (RPO) and recovery time objective
         *        (RTO) values. Currently, Resilience Hub supports only <b>NotEqual</b> difference type.
         * @see DifferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceType
         */
        Builder diffType(DifferenceType diffType);

        /**
         * <p>
         * The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift type.
         * </p>
         * 
         * @param driftType
         *        The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift
         *        type.
         * @see DriftType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriftType
         */
        Builder driftType(String driftType);

        /**
         * <p>
         * The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift type.
         * </p>
         * 
         * @param driftType
         *        The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift
         *        type.
         * @see DriftType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriftType
         */
        Builder driftType(DriftType driftType);

        /**
         * <p>
         * Identifier of an entity in which drift was detected. For compliance drift, the entity ID can be either
         * application ID or the AppComponent ID.
         * </p>
         * 
         * @param entityId
         *        Identifier of an entity in which drift was detected. For compliance drift, the entity ID can be either
         *        application ID or the AppComponent ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The type of entity in which drift was detected. For compliance drifts, Resilience Hub supports
         * <code>AWS::ResilienceHub::AppComponent</code> and <code>AWS::ResilienceHub::Application</code>.
         * </p>
         * 
         * @param entityType
         *        The type of entity in which drift was detected. For compliance drifts, Resilience Hub supports
         *        <code>AWS::ResilienceHub::AppComponent</code> and <code>AWS::ResilienceHub::Application</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * Assessment identifier of a previous assessment of the same application version. Resilience Hub uses the
         * previous assessment (associated with the reference identifier) to compare the compliance with the current
         * assessment to identify drifts.
         * </p>
         * 
         * @param expectedReferenceId
         *        Assessment identifier of a previous assessment of the same application version. Resilience Hub uses
         *        the previous assessment (associated with the reference identifier) to compare the compliance with the
         *        current assessment to identify drifts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedReferenceId(String expectedReferenceId);

        /**
         * <p>
         * The expected compliance value of an entity.
         * </p>
         * 
         * @param expectedValue
         *        The expected compliance value of an entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedValueWithStrings(Map<String, DisruptionCompliance> expectedValue);

        /**
         * <p>
         * The expected compliance value of an entity.
         * </p>
         * 
         * @param expectedValue
         *        The expected compliance value of an entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedValue(Map<DisruptionType, DisruptionCompliance> expectedValue);
    }

    static final class BuilderImpl implements Builder {
        private String actualReferenceId;

        private Map<String, DisruptionCompliance> actualValue = DefaultSdkAutoConstructMap.getInstance();

        private String appId;

        private String appVersion;

        private String diffType;

        private String driftType;

        private String entityId;

        private String entityType;

        private String expectedReferenceId;

        private Map<String, DisruptionCompliance> expectedValue = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceDrift model) {
            actualReferenceId(model.actualReferenceId);
            actualValueWithStrings(model.actualValue);
            appId(model.appId);
            appVersion(model.appVersion);
            diffType(model.diffType);
            driftType(model.driftType);
            entityId(model.entityId);
            entityType(model.entityType);
            expectedReferenceId(model.expectedReferenceId);
            expectedValueWithStrings(model.expectedValue);
        }

        public final String getActualReferenceId() {
            return actualReferenceId;
        }

        public final void setActualReferenceId(String actualReferenceId) {
            this.actualReferenceId = actualReferenceId;
        }

        @Override
        public final Builder actualReferenceId(String actualReferenceId) {
            this.actualReferenceId = actualReferenceId;
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getActualValue() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.actualValue);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActualValue(Map<String, DisruptionCompliance.BuilderImpl> actualValue) {
            this.actualValue = AssessmentComplianceCopier.copyFromBuilder(actualValue);
        }

        @Override
        public final Builder actualValueWithStrings(Map<String, DisruptionCompliance> actualValue) {
            this.actualValue = AssessmentComplianceCopier.copy(actualValue);
            return this;
        }

        @Override
        public final Builder actualValue(Map<DisruptionType, DisruptionCompliance> actualValue) {
            this.actualValue = AssessmentComplianceCopier.copyEnumToString(actualValue);
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getDiffType() {
            return diffType;
        }

        public final void setDiffType(String diffType) {
            this.diffType = diffType;
        }

        @Override
        public final Builder diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        @Override
        public final Builder diffType(DifferenceType diffType) {
            this.diffType(diffType == null ? null : diffType.toString());
            return this;
        }

        public final String getDriftType() {
            return driftType;
        }

        public final void setDriftType(String driftType) {
            this.driftType = driftType;
        }

        @Override
        public final Builder driftType(String driftType) {
            this.driftType = driftType;
            return this;
        }

        @Override
        public final Builder driftType(DriftType driftType) {
            this.driftType(driftType == null ? null : driftType.toString());
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getExpectedReferenceId() {
            return expectedReferenceId;
        }

        public final void setExpectedReferenceId(String expectedReferenceId) {
            this.expectedReferenceId = expectedReferenceId;
        }

        @Override
        public final Builder expectedReferenceId(String expectedReferenceId) {
            this.expectedReferenceId = expectedReferenceId;
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getExpectedValue() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.expectedValue);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExpectedValue(Map<String, DisruptionCompliance.BuilderImpl> expectedValue) {
            this.expectedValue = AssessmentComplianceCopier.copyFromBuilder(expectedValue);
        }

        @Override
        public final Builder expectedValueWithStrings(Map<String, DisruptionCompliance> expectedValue) {
            this.expectedValue = AssessmentComplianceCopier.copy(expectedValue);
            return this;
        }

        @Override
        public final Builder expectedValue(Map<DisruptionType, DisruptionCompliance> expectedValue) {
            this.expectedValue = AssessmentComplianceCopier.copyEnumToString(expectedValue);
            return this;
        }

        @Override
        public ComplianceDrift build() {
            return new ComplianceDrift(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
