/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateRecommendationStatusResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<BatchUpdateRecommendationStatusResponse.Builder, BatchUpdateRecommendationStatusResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(BatchUpdateRecommendationStatusResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<List<BatchUpdateRecommendationStatusFailedEntry>> FAILED_ENTRIES_FIELD = SdkField
            .<List<BatchUpdateRecommendationStatusFailedEntry>> builder(MarshallingType.LIST)
            .memberName("failedEntries")
            .getter(getter(BatchUpdateRecommendationStatusResponse::failedEntries))
            .setter(setter(Builder::failedEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateRecommendationStatusFailedEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateRecommendationStatusFailedEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchUpdateRecommendationStatusSuccessfulEntry>> SUCCESSFUL_ENTRIES_FIELD = SdkField
            .<List<BatchUpdateRecommendationStatusSuccessfulEntry>> builder(MarshallingType.LIST)
            .memberName("successfulEntries")
            .getter(getter(BatchUpdateRecommendationStatusResponse::successfulEntries))
            .setter(setter(Builder::successfulEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateRecommendationStatusSuccessfulEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateRecommendationStatusSuccessfulEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            FAILED_ENTRIES_FIELD, SUCCESSFUL_ENTRIES_FIELD));

    private final String appArn;

    private final List<BatchUpdateRecommendationStatusFailedEntry> failedEntries;

    private final List<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries;

    private BatchUpdateRecommendationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.failedEntries = builder.failedEntries;
        this.successfulEntries = builder.successfulEntries;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedEntries() {
        return failedEntries != null && !(failedEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of items with error details about each item, which could not be included or excluded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedEntries} method.
     * </p>
     * 
     * @return A list of items with error details about each item, which could not be included or excluded.
     */
    public final List<BatchUpdateRecommendationStatusFailedEntry> failedEntries() {
        return failedEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulEntries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessfulEntries() {
        return successfulEntries != null && !(successfulEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of items that were included or excluded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulEntries} method.
     * </p>
     * 
     * @return A list of items that were included or excluded.
     */
    public final List<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries() {
        return successfulEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedEntries() ? failedEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulEntries() ? successfulEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRecommendationStatusResponse)) {
            return false;
        }
        BatchUpdateRecommendationStatusResponse other = (BatchUpdateRecommendationStatusResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && hasFailedEntries() == other.hasFailedEntries()
                && Objects.equals(failedEntries(), other.failedEntries())
                && hasSuccessfulEntries() == other.hasSuccessfulEntries()
                && Objects.equals(successfulEntries(), other.successfulEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateRecommendationStatusResponse").add("AppArn", appArn())
                .add("FailedEntries", hasFailedEntries() ? failedEntries() : null)
                .add("SuccessfulEntries", hasSuccessfulEntries() ? successfulEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "failedEntries":
            return Optional.ofNullable(clazz.cast(failedEntries()));
        case "successfulEntries":
            return Optional.ofNullable(clazz.cast(successfulEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRecommendationStatusResponse, T> g) {
        return obj -> g.apply((BatchUpdateRecommendationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateRecommendationStatusResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * A list of items with error details about each item, which could not be included or excluded.
         * </p>
         * 
         * @param failedEntries
         *        A list of items with error details about each item, which could not be included or excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntries(Collection<BatchUpdateRecommendationStatusFailedEntry> failedEntries);

        /**
         * <p>
         * A list of items with error details about each item, which could not be included or excluded.
         * </p>
         * 
         * @param failedEntries
         *        A list of items with error details about each item, which could not be included or excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntries(BatchUpdateRecommendationStatusFailedEntry... failedEntries);

        /**
         * <p>
         * A list of items with error details about each item, which could not be included or excluded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusFailedEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusFailedEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusFailedEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failedEntries(List<BatchUpdateRecommendationStatusFailedEntry>)}.
         * 
         * @param failedEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusFailedEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedEntries(java.util.Collection<BatchUpdateRecommendationStatusFailedEntry>)
         */
        Builder failedEntries(Consumer<BatchUpdateRecommendationStatusFailedEntry.Builder>... failedEntries);

        /**
         * <p>
         * A list of items that were included or excluded.
         * </p>
         * 
         * @param successfulEntries
         *        A list of items that were included or excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulEntries(Collection<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries);

        /**
         * <p>
         * A list of items that were included or excluded.
         * </p>
         * 
         * @param successfulEntries
         *        A list of items that were included or excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulEntries(BatchUpdateRecommendationStatusSuccessfulEntry... successfulEntries);

        /**
         * <p>
         * A list of items that were included or excluded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusSuccessfulEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusSuccessfulEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusSuccessfulEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successfulEntries(List<BatchUpdateRecommendationStatusSuccessfulEntry>)}.
         * 
         * @param successfulEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.BatchUpdateRecommendationStatusSuccessfulEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulEntries(java.util.Collection<BatchUpdateRecommendationStatusSuccessfulEntry>)
         */
        Builder successfulEntries(Consumer<BatchUpdateRecommendationStatusSuccessfulEntry.Builder>... successfulEntries);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String appArn;

        private List<BatchUpdateRecommendationStatusFailedEntry> failedEntries = DefaultSdkAutoConstructList.getInstance();

        private List<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRecommendationStatusResponse model) {
            super(model);
            appArn(model.appArn);
            failedEntries(model.failedEntries);
            successfulEntries(model.successfulEntries);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<BatchUpdateRecommendationStatusFailedEntry.Builder> getFailedEntries() {
            List<BatchUpdateRecommendationStatusFailedEntry.Builder> result = BatchUpdateRecommendationStatusFailedEntriesCopier
                    .copyToBuilder(this.failedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedEntries(Collection<BatchUpdateRecommendationStatusFailedEntry.BuilderImpl> failedEntries) {
            this.failedEntries = BatchUpdateRecommendationStatusFailedEntriesCopier.copyFromBuilder(failedEntries);
        }

        @Override
        public final Builder failedEntries(Collection<BatchUpdateRecommendationStatusFailedEntry> failedEntries) {
            this.failedEntries = BatchUpdateRecommendationStatusFailedEntriesCopier.copy(failedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(BatchUpdateRecommendationStatusFailedEntry... failedEntries) {
            failedEntries(Arrays.asList(failedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(Consumer<BatchUpdateRecommendationStatusFailedEntry.Builder>... failedEntries) {
            failedEntries(Stream.of(failedEntries)
                    .map(c -> BatchUpdateRecommendationStatusFailedEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateRecommendationStatusSuccessfulEntry.Builder> getSuccessfulEntries() {
            List<BatchUpdateRecommendationStatusSuccessfulEntry.Builder> result = BatchUpdateRecommendationStatusSuccessfulEntriesCopier
                    .copyToBuilder(this.successfulEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulEntries(
                Collection<BatchUpdateRecommendationStatusSuccessfulEntry.BuilderImpl> successfulEntries) {
            this.successfulEntries = BatchUpdateRecommendationStatusSuccessfulEntriesCopier.copyFromBuilder(successfulEntries);
        }

        @Override
        public final Builder successfulEntries(Collection<BatchUpdateRecommendationStatusSuccessfulEntry> successfulEntries) {
            this.successfulEntries = BatchUpdateRecommendationStatusSuccessfulEntriesCopier.copy(successfulEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulEntries(BatchUpdateRecommendationStatusSuccessfulEntry... successfulEntries) {
            successfulEntries(Arrays.asList(successfulEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulEntries(
                Consumer<BatchUpdateRecommendationStatusSuccessfulEntry.Builder>... successfulEntries) {
            successfulEntries(Stream.of(successfulEntries)
                    .map(c -> BatchUpdateRecommendationStatusSuccessfulEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateRecommendationStatusResponse build() {
            return new BatchUpdateRecommendationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
