/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestRecommendationsResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListTestRecommendationsResponse.Builder, ListTestRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestRecommendationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<TestRecommendation>> TEST_RECOMMENDATIONS_FIELD = SdkField
            .<List<TestRecommendation>> builder(MarshallingType.LIST)
            .memberName("testRecommendations")
            .getter(getter(ListTestRecommendationsResponse::testRecommendations))
            .setter(setter(Builder::testRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TEST_RECOMMENDATIONS_FIELD));

    private final String nextToken;

    private final List<TestRecommendation> testRecommendations;

    private ListTestRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.testRecommendations = builder.testRecommendations;
    }

    /**
     * <p>
     * Token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return Token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestRecommendations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestRecommendations() {
        return testRecommendations != null && !(testRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The test recommendations for the Resilience Hub application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestRecommendations} method.
     * </p>
     * 
     * @return The test recommendations for the Resilience Hub application.
     */
    public final List<TestRecommendation> testRecommendations() {
        return testRecommendations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTestRecommendations() ? testRecommendations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestRecommendationsResponse)) {
            return false;
        }
        ListTestRecommendationsResponse other = (ListTestRecommendationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTestRecommendations() == other.hasTestRecommendations()
                && Objects.equals(testRecommendations(), other.testRecommendations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestRecommendationsResponse").add("NextToken", nextToken())
                .add("TestRecommendations", hasTestRecommendations() ? testRecommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "testRecommendations":
            return Optional.ofNullable(clazz.cast(testRecommendations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestRecommendationsResponse, T> g) {
        return obj -> g.apply((ListTestRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTestRecommendationsResponse> {
        /**
         * <p>
         * Token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The test recommendations for the Resilience Hub application.
         * </p>
         * 
         * @param testRecommendations
         *        The test recommendations for the Resilience Hub application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRecommendations(Collection<TestRecommendation> testRecommendations);

        /**
         * <p>
         * The test recommendations for the Resilience Hub application.
         * </p>
         * 
         * @param testRecommendations
         *        The test recommendations for the Resilience Hub application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRecommendations(TestRecommendation... testRecommendations);

        /**
         * <p>
         * The test recommendations for the Resilience Hub application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.TestRecommendation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.TestRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.TestRecommendation.Builder#build()} is called
         * immediately and its result is passed to {@link #testRecommendations(List<TestRecommendation>)}.
         * 
         * @param testRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.TestRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testRecommendations(java.util.Collection<TestRecommendation>)
         */
        Builder testRecommendations(Consumer<TestRecommendation.Builder>... testRecommendations);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TestRecommendation> testRecommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestRecommendationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            testRecommendations(model.testRecommendations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TestRecommendation.Builder> getTestRecommendations() {
            List<TestRecommendation.Builder> result = TestRecommendationListCopier.copyToBuilder(this.testRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestRecommendations(Collection<TestRecommendation.BuilderImpl> testRecommendations) {
            this.testRecommendations = TestRecommendationListCopier.copyFromBuilder(testRecommendations);
        }

        @Override
        public final Builder testRecommendations(Collection<TestRecommendation> testRecommendations) {
            this.testRecommendations = TestRecommendationListCopier.copy(testRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRecommendations(TestRecommendation... testRecommendations) {
            testRecommendations(Arrays.asList(testRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRecommendations(Consumer<TestRecommendation.Builder>... testRecommendations) {
            testRecommendations(Stream.of(testRecommendations).map(c -> TestRecommendation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTestRecommendationsResponse build() {
            return new ListTestRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
