/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the compliance against the resiliency policy for a disruption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisruptionCompliance implements SdkPojo, Serializable,
        ToCopyableBuilder<DisruptionCompliance.Builder, DisruptionCompliance> {
    private static final SdkField<Integer> ACHIEVABLE_RPO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("achievableRpoInSecs").getter(getter(DisruptionCompliance::achievableRpoInSecs))
            .setter(setter(Builder::achievableRpoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("achievableRpoInSecs").build())
            .build();

    private static final SdkField<Integer> ACHIEVABLE_RTO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("achievableRtoInSecs").getter(getter(DisruptionCompliance::achievableRtoInSecs))
            .setter(setter(Builder::achievableRtoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("achievableRtoInSecs").build())
            .build();

    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceStatus").getter(getter(DisruptionCompliance::complianceStatusAsString))
            .setter(setter(Builder::complianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()).build();

    private static final SdkField<Integer> CURRENT_RPO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("currentRpoInSecs").getter(getter(DisruptionCompliance::currentRpoInSecs))
            .setter(setter(Builder::currentRpoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRpoInSecs").build()).build();

    private static final SdkField<Integer> CURRENT_RTO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("currentRtoInSecs").getter(getter(DisruptionCompliance::currentRtoInSecs))
            .setter(setter(Builder::currentRtoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRtoInSecs").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(DisruptionCompliance::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> RPO_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rpoDescription").getter(getter(DisruptionCompliance::rpoDescription))
            .setter(setter(Builder::rpoDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rpoDescription").build()).build();

    private static final SdkField<String> RPO_REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rpoReferenceId").getter(getter(DisruptionCompliance::rpoReferenceId))
            .setter(setter(Builder::rpoReferenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rpoReferenceId").build()).build();

    private static final SdkField<String> RTO_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rtoDescription").getter(getter(DisruptionCompliance::rtoDescription))
            .setter(setter(Builder::rtoDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtoDescription").build()).build();

    private static final SdkField<String> RTO_REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rtoReferenceId").getter(getter(DisruptionCompliance::rtoReferenceId))
            .setter(setter(Builder::rtoReferenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtoReferenceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACHIEVABLE_RPO_IN_SECS_FIELD,
            ACHIEVABLE_RTO_IN_SECS_FIELD, COMPLIANCE_STATUS_FIELD, CURRENT_RPO_IN_SECS_FIELD, CURRENT_RTO_IN_SECS_FIELD,
            MESSAGE_FIELD, RPO_DESCRIPTION_FIELD, RPO_REFERENCE_ID_FIELD, RTO_DESCRIPTION_FIELD, RTO_REFERENCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer achievableRpoInSecs;

    private final Integer achievableRtoInSecs;

    private final String complianceStatus;

    private final Integer currentRpoInSecs;

    private final Integer currentRtoInSecs;

    private final String message;

    private final String rpoDescription;

    private final String rpoReferenceId;

    private final String rtoDescription;

    private final String rtoReferenceId;

    private DisruptionCompliance(BuilderImpl builder) {
        this.achievableRpoInSecs = builder.achievableRpoInSecs;
        this.achievableRtoInSecs = builder.achievableRtoInSecs;
        this.complianceStatus = builder.complianceStatus;
        this.currentRpoInSecs = builder.currentRpoInSecs;
        this.currentRtoInSecs = builder.currentRtoInSecs;
        this.message = builder.message;
        this.rpoDescription = builder.rpoDescription;
        this.rpoReferenceId = builder.rpoReferenceId;
        this.rtoDescription = builder.rtoDescription;
        this.rtoReferenceId = builder.rtoReferenceId;
    }

    /**
     * <p>
     * The Recovery Point Objective (RPO) that is achievable, in seconds.
     * </p>
     * 
     * @return The Recovery Point Objective (RPO) that is achievable, in seconds.
     */
    public final Integer achievableRpoInSecs() {
        return achievableRpoInSecs;
    }

    /**
     * <p>
     * The Recovery Time Objective (RTO) that is achievable, in seconds
     * </p>
     * 
     * @return The Recovery Time Objective (RTO) that is achievable, in seconds
     */
    public final Integer achievableRtoInSecs() {
        return achievableRtoInSecs;
    }

    /**
     * <p>
     * The current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return The current status of compliance for the resiliency policy.
     * @see ComplianceStatus
     */
    public final ComplianceStatus complianceStatus() {
        return ComplianceStatus.fromValue(complianceStatus);
    }

    /**
     * <p>
     * The current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return The current status of compliance for the resiliency policy.
     * @see ComplianceStatus
     */
    public final String complianceStatusAsString() {
        return complianceStatus;
    }

    /**
     * <p>
     * The current RPO, in seconds.
     * </p>
     * 
     * @return The current RPO, in seconds.
     */
    public final Integer currentRpoInSecs() {
        return currentRpoInSecs;
    }

    /**
     * <p>
     * The current RTO, in seconds.
     * </p>
     * 
     * @return The current RTO, in seconds.
     */
    public final Integer currentRtoInSecs() {
        return currentRtoInSecs;
    }

    /**
     * <p>
     * The disruption compliance message.
     * </p>
     * 
     * @return The disruption compliance message.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The RPO description.
     * </p>
     * 
     * @return The RPO description.
     */
    public final String rpoDescription() {
        return rpoDescription;
    }

    /**
     * <p>
     * Reference identifier of the RPO .
     * </p>
     * 
     * @return Reference identifier of the RPO .
     */
    public final String rpoReferenceId() {
        return rpoReferenceId;
    }

    /**
     * <p>
     * The RTO description.
     * </p>
     * 
     * @return The RTO description.
     */
    public final String rtoDescription() {
        return rtoDescription;
    }

    /**
     * <p>
     * Reference identifier of the RTO.
     * </p>
     * 
     * @return Reference identifier of the RTO.
     */
    public final String rtoReferenceId() {
        return rtoReferenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(achievableRpoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(achievableRtoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentRpoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(currentRtoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(rpoDescription());
        hashCode = 31 * hashCode + Objects.hashCode(rpoReferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(rtoDescription());
        hashCode = 31 * hashCode + Objects.hashCode(rtoReferenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisruptionCompliance)) {
            return false;
        }
        DisruptionCompliance other = (DisruptionCompliance) obj;
        return Objects.equals(achievableRpoInSecs(), other.achievableRpoInSecs())
                && Objects.equals(achievableRtoInSecs(), other.achievableRtoInSecs())
                && Objects.equals(complianceStatusAsString(), other.complianceStatusAsString())
                && Objects.equals(currentRpoInSecs(), other.currentRpoInSecs())
                && Objects.equals(currentRtoInSecs(), other.currentRtoInSecs()) && Objects.equals(message(), other.message())
                && Objects.equals(rpoDescription(), other.rpoDescription())
                && Objects.equals(rpoReferenceId(), other.rpoReferenceId())
                && Objects.equals(rtoDescription(), other.rtoDescription())
                && Objects.equals(rtoReferenceId(), other.rtoReferenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisruptionCompliance").add("AchievableRpoInSecs", achievableRpoInSecs())
                .add("AchievableRtoInSecs", achievableRtoInSecs()).add("ComplianceStatus", complianceStatusAsString())
                .add("CurrentRpoInSecs", currentRpoInSecs()).add("CurrentRtoInSecs", currentRtoInSecs())
                .add("Message", message()).add("RpoDescription", rpoDescription()).add("RpoReferenceId", rpoReferenceId())
                .add("RtoDescription", rtoDescription()).add("RtoReferenceId", rtoReferenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "achievableRpoInSecs":
            return Optional.ofNullable(clazz.cast(achievableRpoInSecs()));
        case "achievableRtoInSecs":
            return Optional.ofNullable(clazz.cast(achievableRtoInSecs()));
        case "complianceStatus":
            return Optional.ofNullable(clazz.cast(complianceStatusAsString()));
        case "currentRpoInSecs":
            return Optional.ofNullable(clazz.cast(currentRpoInSecs()));
        case "currentRtoInSecs":
            return Optional.ofNullable(clazz.cast(currentRtoInSecs()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "rpoDescription":
            return Optional.ofNullable(clazz.cast(rpoDescription()));
        case "rpoReferenceId":
            return Optional.ofNullable(clazz.cast(rpoReferenceId()));
        case "rtoDescription":
            return Optional.ofNullable(clazz.cast(rtoDescription()));
        case "rtoReferenceId":
            return Optional.ofNullable(clazz.cast(rtoReferenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisruptionCompliance, T> g) {
        return obj -> g.apply((DisruptionCompliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisruptionCompliance> {
        /**
         * <p>
         * The Recovery Point Objective (RPO) that is achievable, in seconds.
         * </p>
         * 
         * @param achievableRpoInSecs
         *        The Recovery Point Objective (RPO) that is achievable, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder achievableRpoInSecs(Integer achievableRpoInSecs);

        /**
         * <p>
         * The Recovery Time Objective (RTO) that is achievable, in seconds
         * </p>
         * 
         * @param achievableRtoInSecs
         *        The Recovery Time Objective (RTO) that is achievable, in seconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder achievableRtoInSecs(Integer achievableRtoInSecs);

        /**
         * <p>
         * The current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        The current status of compliance for the resiliency policy.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder complianceStatus(String complianceStatus);

        /**
         * <p>
         * The current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        The current status of compliance for the resiliency policy.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder complianceStatus(ComplianceStatus complianceStatus);

        /**
         * <p>
         * The current RPO, in seconds.
         * </p>
         * 
         * @param currentRpoInSecs
         *        The current RPO, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRpoInSecs(Integer currentRpoInSecs);

        /**
         * <p>
         * The current RTO, in seconds.
         * </p>
         * 
         * @param currentRtoInSecs
         *        The current RTO, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRtoInSecs(Integer currentRtoInSecs);

        /**
         * <p>
         * The disruption compliance message.
         * </p>
         * 
         * @param message
         *        The disruption compliance message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The RPO description.
         * </p>
         * 
         * @param rpoDescription
         *        The RPO description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rpoDescription(String rpoDescription);

        /**
         * <p>
         * Reference identifier of the RPO .
         * </p>
         * 
         * @param rpoReferenceId
         *        Reference identifier of the RPO .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rpoReferenceId(String rpoReferenceId);

        /**
         * <p>
         * The RTO description.
         * </p>
         * 
         * @param rtoDescription
         *        The RTO description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtoDescription(String rtoDescription);

        /**
         * <p>
         * Reference identifier of the RTO.
         * </p>
         * 
         * @param rtoReferenceId
         *        Reference identifier of the RTO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtoReferenceId(String rtoReferenceId);
    }

    static final class BuilderImpl implements Builder {
        private Integer achievableRpoInSecs;

        private Integer achievableRtoInSecs;

        private String complianceStatus;

        private Integer currentRpoInSecs;

        private Integer currentRtoInSecs;

        private String message;

        private String rpoDescription;

        private String rpoReferenceId;

        private String rtoDescription;

        private String rtoReferenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisruptionCompliance model) {
            achievableRpoInSecs(model.achievableRpoInSecs);
            achievableRtoInSecs(model.achievableRtoInSecs);
            complianceStatus(model.complianceStatus);
            currentRpoInSecs(model.currentRpoInSecs);
            currentRtoInSecs(model.currentRtoInSecs);
            message(model.message);
            rpoDescription(model.rpoDescription);
            rpoReferenceId(model.rpoReferenceId);
            rtoDescription(model.rtoDescription);
            rtoReferenceId(model.rtoReferenceId);
        }

        public final Integer getAchievableRpoInSecs() {
            return achievableRpoInSecs;
        }

        public final void setAchievableRpoInSecs(Integer achievableRpoInSecs) {
            this.achievableRpoInSecs = achievableRpoInSecs;
        }

        @Override
        public final Builder achievableRpoInSecs(Integer achievableRpoInSecs) {
            this.achievableRpoInSecs = achievableRpoInSecs;
            return this;
        }

        public final Integer getAchievableRtoInSecs() {
            return achievableRtoInSecs;
        }

        public final void setAchievableRtoInSecs(Integer achievableRtoInSecs) {
            this.achievableRtoInSecs = achievableRtoInSecs;
        }

        @Override
        public final Builder achievableRtoInSecs(Integer achievableRtoInSecs) {
            this.achievableRtoInSecs = achievableRtoInSecs;
            return this;
        }

        public final String getComplianceStatus() {
            return complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(ComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Integer getCurrentRpoInSecs() {
            return currentRpoInSecs;
        }

        public final void setCurrentRpoInSecs(Integer currentRpoInSecs) {
            this.currentRpoInSecs = currentRpoInSecs;
        }

        @Override
        public final Builder currentRpoInSecs(Integer currentRpoInSecs) {
            this.currentRpoInSecs = currentRpoInSecs;
            return this;
        }

        public final Integer getCurrentRtoInSecs() {
            return currentRtoInSecs;
        }

        public final void setCurrentRtoInSecs(Integer currentRtoInSecs) {
            this.currentRtoInSecs = currentRtoInSecs;
        }

        @Override
        public final Builder currentRtoInSecs(Integer currentRtoInSecs) {
            this.currentRtoInSecs = currentRtoInSecs;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getRpoDescription() {
            return rpoDescription;
        }

        public final void setRpoDescription(String rpoDescription) {
            this.rpoDescription = rpoDescription;
        }

        @Override
        public final Builder rpoDescription(String rpoDescription) {
            this.rpoDescription = rpoDescription;
            return this;
        }

        public final String getRpoReferenceId() {
            return rpoReferenceId;
        }

        public final void setRpoReferenceId(String rpoReferenceId) {
            this.rpoReferenceId = rpoReferenceId;
        }

        @Override
        public final Builder rpoReferenceId(String rpoReferenceId) {
            this.rpoReferenceId = rpoReferenceId;
            return this;
        }

        public final String getRtoDescription() {
            return rtoDescription;
        }

        public final void setRtoDescription(String rtoDescription) {
            this.rtoDescription = rtoDescription;
        }

        @Override
        public final Builder rtoDescription(String rtoDescription) {
            this.rtoDescription = rtoDescription;
            return this;
        }

        public final String getRtoReferenceId() {
            return rtoReferenceId;
        }

        public final void setRtoReferenceId(String rtoReferenceId) {
            this.rtoReferenceId = rtoReferenceId;
        }

        @Override
        public final Builder rtoReferenceId(String rtoReferenceId) {
            this.rtoReferenceId = rtoReferenceId;
            return this;
        }

        @Override
        public DisruptionCompliance build() {
            return new DisruptionCompliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
