/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class RecommendationComplianceCopier {
    static Map<String, RecommendationDisruptionCompliance> copy(
            Map<String, ? extends RecommendationDisruptionCompliance> recommendationComplianceParam) {
        Map<String, RecommendationDisruptionCompliance> map;
        if (recommendationComplianceParam == null || recommendationComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RecommendationDisruptionCompliance> modifiableMap = new LinkedHashMap<>();
            recommendationComplianceParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, RecommendationDisruptionCompliance> copyFromBuilder(
            Map<String, ? extends RecommendationDisruptionCompliance.Builder> recommendationComplianceParam) {
        Map<String, RecommendationDisruptionCompliance> map;
        if (recommendationComplianceParam == null || recommendationComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RecommendationDisruptionCompliance> modifiableMap = new LinkedHashMap<>();
            recommendationComplianceParam.forEach((key, value) -> {
                RecommendationDisruptionCompliance member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, RecommendationDisruptionCompliance.Builder> copyToBuilder(
            Map<String, ? extends RecommendationDisruptionCompliance> recommendationComplianceParam) {
        Map<String, RecommendationDisruptionCompliance.Builder> map;
        if (recommendationComplianceParam == null || recommendationComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RecommendationDisruptionCompliance.Builder> modifiableMap = new LinkedHashMap<>();
            recommendationComplianceParam.forEach((key, value) -> {
                RecommendationDisruptionCompliance.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, RecommendationDisruptionCompliance> copyEnumToString(
            Map<DisruptionType, ? extends RecommendationDisruptionCompliance> recommendationComplianceParam) {
        Map<String, RecommendationDisruptionCompliance> map;
        if (recommendationComplianceParam == null || recommendationComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RecommendationDisruptionCompliance> modifiableMap = new LinkedHashMap<>();
            recommendationComplianceParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DisruptionType, RecommendationDisruptionCompliance> copyStringToEnum(
            Map<String, ? extends RecommendationDisruptionCompliance> recommendationComplianceParam) {
        Map<DisruptionType, RecommendationDisruptionCompliance> map;
        if (recommendationComplianceParam == null || recommendationComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DisruptionType, RecommendationDisruptionCompliance> modifiableMap = new LinkedHashMap<>();
            recommendationComplianceParam.forEach((key, value) -> {
                DisruptionType result = DisruptionType.fromValue(key);
                if (result != DisruptionType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
